package DTF.modules;

public class PatternBin {
	private int size;
	private Pattern[] patterns;
	private int insertAt;
	private Pattern last;
	
	public PatternBin(int size) {
		patterns=new Pattern[size];
		this.size=size;
		insertAt=0;
	}
	
	public Pattern findNearest(Pattern search, int requiredTurnsAhead, int maxDiff) {
		Pattern match=null;
		int minDiff=0;
		for(int i=0;i<size;i++) {
			Pattern p=patterns[i];
			if(p!=null) { 
				int diff=search.difference(p);
				if(match==null || diff<minDiff || (diff==minDiff && p.turns>match.turns)) { //turns is tie breaker for equal matches
					if(p.knowAhead(requiredTurnsAhead)) {
						match=p;
						minDiff=diff;
					}
				}
			}
			
		}
		if(minDiff>maxDiff) return null; //unacceptably far away
		return match;
	}
	
	public void addPattern(Pattern p) {
		if(last!=null && p.isEqual(last)) return;
		
		if(patterns[insertAt]!=null) patterns[insertAt].inBin=false;
		
		patterns[insertAt]=p;
		last=p;
		insertAt=(insertAt+1)%size;
		
		p.inBin=true;
		
		//todo pruning of .next patterns most turns away from patterns still binned
	}
	
	public void pruneAfter(int limit) {
		for(int i=0;i<size;i++) {
			Pattern p=patterns[i];
			if(p!=null) p.pruneAfter(limit);
		}
	}
}
