package ag.battledata;


/**
 * A snapshot of one tick of a robot
 * @author Andree Grosse
 */
public class DataRobotSnapshot implements java.io.Serializable {

	static final long serialVersionUID = 1002;
	
	private long mTick;
	private DataVector mPosition;
	private DataVector mDirection;
	private double mVelocity, mEnergy;
	
	/**
	 * Constructor
	 * @param tick Current tick
	 * @param x Position x
	 * @param y Position x
	 * @param direction Direction - must be normalized
	 * @param velocity Non-absolute velocity
	 * @param energy Energy
	 */
	public DataRobotSnapshot(long tick, double x, double y, DataVector direction, double velocity, double energy) {
		mTick = tick;
		mPosition = new DataVector(x, y);
		mDirection = direction;
		mVelocity = velocity;
		mEnergy = energy;
	}
	
	// ####################### setter & getter #######################
	
	/**
	 * Returns the tick this snapshot was made
	 * @return The tick this snapshot was made
	 */
	public long getTick() {
		return mTick;
	}
	
	/**
	 * Returns the position at this snapshot
	 * @return The position at this snapshot
	 */
	public DataVector getPosition() {
		return mPosition;	
	}
	
	/**
	 * Returns the direction for absolute velocity (if the robots moves
	 * backwards, the direction will point backwards)
	 * @return The direction at this snapshot
	 */
	public DataVector getAbsDirection() {
		if(mVelocity >= 0.0)
			return mDirection;
		else
			return mDirection.negative();
	}
	
	/**
	 * Returns the direction for signed velocity (if the robots moves with
	 * negative velocity, the direction will point forward)
	 * @return The direction at this snapshot
	 */
	public DataVector getDirection() {
		return mDirection;	
	}
	
	/**
	 * Returns the absolute velocity
	 * @return The absolute velocity
	 */
	public double getAbsVelocity() {
		return Math.abs(mVelocity);	
	}
	
	/**
	 * Returns the signed velocity
	 * @returns the signed velocity
	 */
	public double getVelocity() {
		return mVelocity;	
	}
		
	/**
	 * Returns the energy
	 * @return The energy
	 */
	public double getEnergy() {
		return mEnergy;	
	}
	// ###############################################################

}	
