package ag.neuralgir;

/**
 * A dataset to train the neural net
 * @author agrosse
 *
 */
public class TrainDataSet {
	private double[] mInput;
	private double[] mOutput;
	private long mTick;
	
	
	/**
	 * Creates a training data set
	 * @param in Net input
	 * @param out Net output
	 */
	public TrainDataSet(int in, int out, long tick){
		mInput = new double[in];
		mOutput = new double[out];
		mTick = tick;
	}
	
	/**
	 * Creates a TrainDataSet by cloning
	 * @param dataset the dataset whoose values shall be copied
	 */
	public TrainDataSet(TrainDataSet dataset){
		mInput = new double[dataset.getInput().length];
		mOutput = new double[dataset.getOutput().length];
		mTick = dataset.getTick();
		
		int i;
		for(i = 0; i < mInput.length; i++)			
			mInput[i] = dataset.getInput()[i];
		for(i = 0; i < mOutput.length; i++)			
			mOutput[i] = dataset.getOutput()[i];		
	}
	
	/**
	 * Empty constructor
	 */
	public TrainDataSet(){
		
	}
	
	/**
	 * Returns the tick for this TrainDataSet
	 */
	public long getTick(){
		return mTick;
	}
	
	
	/**
	 * Returns the input
	 * @return input for the training set
	 */
	public double[] getInput() {
		return mInput;
	}
	
	/**
	 * Returns the output
	 * @return output for the training set
	 */
	public double[] getOutput() {
		return mOutput;
	}
	
	/**
	 * Sets the output for the training set
	 * @param output Correct output
	 */
	public void setOutput(double[] output) {
		mOutput = output;
	}
	
	/**
	 * Sets the input for the training set
	 * @param input
	 */
	public void setInput(double[] input){
		mInput = input;
	}
	
	/**
	 * Returns the concatenation of input and output array
	 * @return An double array containing input followed by output
	 */
	public double[] getDataSet(){
		double[] data = new double[mInput.length + mOutput.length];
		int i;
		for(i = 0; i < mInput.length; i++)
			data[i] = mInput[i];
		for(i =  0; i < mOutput.length; i++)
			data[i + mInput.length] = mOutput[i];
		
		return data;
		
	}
	
}
