package ags.util.points;

import static robocode.util.Utils.normalAbsoluteAngle;

/**
 * @author Alexander Schultz
 */
public class AbsolutePoint extends java.awt.geom.Point2D implements java.io.Serializable {
    private static final long serialVersionUID = 1L;
    public double x, y;
    
    private AbsolutePoint() {}
    
    public double getX() {
        return x;
    }
    public double getY() {
        return y;
    }
    public AbsolutePoint addRelativePoint(RelativePoint rel) {
        return fromXY(x+rel.getX(), y+rel.getY());
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }
    
    public static AbsolutePoint fromXY(double x, double y) {
        AbsolutePoint newpoint = new AbsolutePoint();
        newpoint.setLocation(x, y);
        return newpoint;
    }
    
    public AbsolutePoint project(double direction, double distance) {
        AbsolutePoint projPoint = new AbsolutePoint();
        projPoint.x = x + distance * Math.sin(direction);
        projPoint.y = y + distance * Math.cos(direction);
        return projPoint;
    }
    
    public double angleTo(AbsolutePoint other) {
        return normalAbsoluteAngle(Math.atan2(other.x - x, other.y - y));
    }
}
