package tm;

import java.util.*;

/********************************************************************
* EnemyHistory3c.java -- Gʒu̗pOobt@
*                       ⊮
*
* Date:		2002/Nov/10
*			2003/Jan/05
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class EnemyHistory3c {
	Point[] po;
	double[] heading;			//Gis
	double[] distance;
	double[] absoluteBearing;		//猩G̐Ε
	long[] time;
	int startIndex = -1;
	int endIndex = -1;
	double maxAngle, minAngle;
	int maxIndex, minIndex;
	int size;
	int dataSize = 0;			//ۂ̃f[^
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public EnemyHistory3c(int n) {
		po = new Point[n];
		heading = new double[n];
		distance = new double[n];
		time = new long[n];
		absoluteBearing = new double[n];
		size = n;
	}

	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	void put(double x, double y, double distance, double velocity, double heading, double bearing, long t) {
		int lastIndex = endIndex;

		if (dataSize < size) dataSize++;
			
			
		if (startIndex == -1 && endIndex == -1) {
			startIndex = endIndex = 0;
		} else {
			if (t - time[endIndex] != 1) {
//M.print("currTime = " + t);
//M.print("endIndex time[endIndex] = " + endIndex + " " + this.time[endIndex]);
//if (endIndex > 0)
//	M.print("endIndex-1 time[endIndex-1] = " + (endIndex-1) + " " + this.time[endIndex-1]);
//M.print("currH V = " + heading + " " + velocity);
				//L^ԂsA̎CL^
				double dt = t - time[endIndex];
				double dx = (x - this.po[endIndex].x) / dt;
				double dy = (y - this.po[endIndex].y) / dt;
				double dd = (distance - this.distance[endIndex]) / dt;
				double dh = (heading - this.heading[endIndex]) / dt;
				//double dv = (velocity - this.velocity[endIndex]) / dt;
				double db = (bearing - this.absoluteBearing[endIndex]) / dt;
		
				for (int i = 0; i < dt - 1; i++) {
					endIndex = (endIndex+1) % size;
					if (endIndex == startIndex) {
						startIndex = (startIndex+1) % size;
					}
					this.time[endIndex] = this.time[lastIndex] + 1;
					this.po[endIndex] = new Point(this.po[lastIndex].x + dx, this.po[lastIndex].y + dy);
					this.distance[endIndex] = this.distance[lastIndex] + dd;
					this.heading[endIndex] = this.heading[lastIndex] + dh;
					//this.velocity[endIndex] = this.velocity[lastIndex] + dv;
					this.absoluteBearing[endIndex] = this.absoluteBearing[lastIndex] + db;
					lastIndex = (lastIndex + 1) % size;
					if (dataSize < size) dataSize++;
//M.print("idx time x y distance = " + endIndex + " " + this.time[endIndex] + " " + (int)this.po[endIndex].x + " " + (int)this.po[endIndex].y + " " + this.distance[endIndex]);
				}
			}

			endIndex = (endIndex+1) % size;
			if (endIndex == startIndex) {
				startIndex = (startIndex+1) % size;
			}
		}
			
		
		this.po[endIndex] = new Point(x, y);
		this.distance[endIndex] = distance;
		this.time[endIndex] = t;
		this.absoluteBearing[endIndex] = bearing;
		if (velocity >= 0) {
			this.heading[endIndex] = heading;
		} else {
			this.heading[endIndex] = (heading + 180) % 360;		
		}
	}
}