package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* MoveCornerY.java -- R[i[ɐw荶Eړ
*                     [p
*
* Date:		2002/Nov/16
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class MoveCornerY implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	
	final int NORTH = MyRobot.NORTH;
	final int SOUTH = MyRobot.SOUTH;
	final int WEST = MyRobot.WEST;
	final int EAST = MyRobot.EAST;
	final int NE = MyRobot.NE;
	final int SE = MyRobot.SE;
	final int NW = MyRobot.NW;
	final int SW = MyRobot.SW;	
									
	int nearWall, nearCorner;
	int posIndex = 0;
	double[] xs;
	double[] ys;
	boolean isInitPos = false;
	boolean wallNearF = false;
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public MoveCornerY(MyRobot my) {
		this.my = my;
		fW = my.fW;
		fH = my.fH;
		
		init();
	}
	
	public void init() {
		my.EPSILON = 50;
		dstX = my.getX();
		dstY = my.getY();
		setNearWall();
		setNearCorner();
		createDestination();
		my.setMaxVelocity(8);
	}
	
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		wallNearF = false;
		
		//ʒuɈړ
		if (!isInitPos) {
			//ł߂ǂɒi
			switch (nearWall) {
				case NORTH:
					dstY = fH - 100;
					break;
				case EAST:
					dstX = fW - 100;
					break;
				case SOUTH:
					dstY = 100;
					break;
				case WEST:
					dstX = 100;
					break;
				default:
					;
			}
			
			if (my.isArrived(dstX, dstY)) {
				isInitPos = true;
			}
			my.setGoPos(dstX, dstY);
			return;
		}

		double dx = 0, dy = 0;
		
		//ړݒ
		if (my.isArrived(dstX, dstY)) {
			if (posIndex == 1) {
				dx = rand.nextInt(100) - 50;
				dy = 0;
			} else if (posIndex == 3) {
				dx = 0;
				dy = rand.nextInt(100) - 50;
			}
			dstX = xs[posIndex] + dx;
			dstY = ys[posIndex] + dy;
			posIndex++;
			posIndex = posIndex % xs.length;
			//print("I will go to -- " + dstX + " " + dstY);
		}
		
		my.setGoPos(dstX, dstY);
	}

	//------------------------------------------------------------------
	// createDestination()
	//
	//
	//------------------------------------------------------------------
	void createDestination() {
		int dirX, dirY;
		double ox, oy;
		final int MARGIN = 30;
		final int DIFF = 200;
		
		switch (nearCorner) {
			case  NW:
				dirX = 1;
				dirY = -1;
				ox = MARGIN;
				oy = fH - MARGIN;
				break;
			case NE:
				dirX = -1;
				dirY = -1;
				ox = fW - MARGIN;
				oy = fH - MARGIN;				
				break;
			case SE:
				dirX = -1;
				dirY = 1;
				ox = fW - MARGIN;
				oy = MARGIN;
				break;
			case SW:
			default:
				dirX = 1;
				dirY = 1;
				ox = MARGIN;
				oy = MARGIN;
				break;
		}
		
		xs = new double[4];
		ys = new double[4];
		
		xs[0] = ox + 60 * dirX;
		ys[0] = oy + 60 * dirY;
		xs[1] = ox + DIFF * dirX;
		ys[1] = oy;		
		xs[2] = xs[0];
		ys[2] = ys[0];		
		xs[3] = ox;
		ys[3] = oy + DIFF * dirY;		
	}


	//------------------------------------------------------------------
	// setNearWall()
	//
	//
	//------------------------------------------------------------------
	void setNearWall() {
		double min = my.getX();
		double myX = my.getX();
		double myY = my.getY();
		
		nearWall = WEST;
		dstX = myX;
		dstY = myY;
		
		//Ƃ߂ǂ̕ṕH
		if (min > fH - myY) {
			nearWall = NORTH;
			min = fH - myY;
		}

		if (min > fW - myX) {
			nearWall = EAST;
			min = fW - myX;
		}
		
		if (min > myY) {
			nearWall = SOUTH;
			min = myY;
		}
	}
		
	//------------------------------------------------------------------
	// setNearCorner()
	//
	//
	//------------------------------------------------------------------
	void setNearCorner() {
		double myX = my.getX();
		double myY = my.getY();
		
		if (nearWall == NORTH) {
			if (myX < fW - myX) nearCorner = NW;
			else                      nearCorner = NE;
		} else if (nearWall == EAST) {
			if (myY < fH - myY) nearCorner = SE;
			else                      nearCorner = NE;				
		} else if (nearWall == SOUTH) {
			if (myX < fW - myX) nearCorner = SW;
			else                      nearCorner = SE;
		} else if (nearWall == WEST) {
			if (myY < fH - myY) nearCorner = SW;
			else                      nearCorner = NW;				
		}
	}

	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		int dirX, dirY;
		
		if (wallNearF) {
			setNearWall();
			setNearCorner();
			
			switch (nearCorner) {
			case  NW:
				dirX = 1;
				dirY = -1;
				break;
			case NE:
				dirX = -1;
				dirY = -1;			
				break;
			case SE:
				dirX = -1;
				dirY = 1;
				break;
			case SW:
			default:
				dirX = 1;
				dirY = 1;
				break;
			}
			dstX = my.getX() + 50 * dirX;
			dstY = my.getY() + 50 * dirY;
			my.setGoPos(dstX, dstY);
			return;		
		}
		
		my.setMaxVelocity(2);
		my.execute();
		my.setMaxVelocity(8);

		wallNearF = true;
//M.print("wall near!!");
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {
		my.result.damage();
	}
	
	//--------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 30;
		
		if (dstX < MARGIN) dstX = MARGIN;
		else if (fW - dstX < MARGIN)  dstX = fW - MARGIN;
		if (dstY < MARGIN) dstY = MARGIN;
		else  if (fH - dstY < MARGIN) dstY = fH - MARGIN;
	}

	//---------------------------------
	//
	//--------------------------------
	private void setSpeed() {
		double dx = dstX - my.getX();
		double dy = dstY - my.getY();
		double d = Math.sqrt(dx * dx + dy * dy);
		double v = Math.min(d * 8.0 / 50.0, 8.0);
		
		my.setMaxVelocity(v);
		M.print("set speed = " + v + " " + d);
	}
	
	
	//------------------------------------------------------------------
	// scannedRobot()
	//
	//
	//------------------------------------------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
	}
}