package pl.robocode.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Util {

    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 200;

    public static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(getNextLocation(botLocation, angle, WALL_STICK))) {
            angle += orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double getNextLocation(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
    
}
