package axeBots.silversurfer;
import robocode.*;
import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.data.PMShootingData;
import axeBots.gunner.AxeGunner;
import axeBots.gunner.VectorPMGun;
import axeBots.util.RoboMath;

public class BulletTracker extends Condition {
	
	private static double[] hitsRA = new double[6];
	private static int[] hitsCount = new int [6];
	private static int[] bullCount = new int[6];
	
    private long expectedTimeOfImpact;
    private String targetName;
	private AxeGunner gun;
    private Bullet bullet;
    private AdvancedRobot myRobot;
    private int aimMethod;
    private boolean hitTarget;
    //private boolean             shouldHit = false;
    private double targetDist;
    private Point2D.Double impactPt = null;
    //private Point2D.Double		myFirePos = null;
    private double impactTime = Double.NaN;
    private double facingAngle = 0;
    private long startTime = 0;
    
    private Point2D.Double firePt = null;
    private Point2D.Double bulletPt = new Point2D.Double();
    private Point2D.Double targetPt = new Point2D.Double();
    private AxeTarget him = null;
    //private AxeVector missVec = null;
    private AxeVector meToTarg = null;
	private PMShootingData pmData;

    public BulletTracker(
        AdvancedRobot ar,
        Bullet b,
        String targetName,
        long timeToImpact,
        int aimMethod,
        double targetDist,
        double angle,
        Point2D.Double pt,
        AxeVector meToTarg, AxeGunner gun) {

        if (b != null) {
        	this.gun = gun;
            this.myRobot = ar;
            this.bullet = b;
            this.targetName = targetName;
            this.expectedTimeOfImpact = ar.getTime() + timeToImpact;
            this.aimMethod = aimMethod;
            this.hitTarget = false;
            this.targetDist = targetDist;
            this.impactPt = pt;
            this.meToTarg = meToTarg;
            this.setFacingAngle(angle);
            this.startTime = ar.getTime();
            this.firePt = AxeBot.getIt().pos();
            
//            System.out.println(" firePt:" + firePt);
//            System.out.println(" fireAng:" + RoboMath.normalRelativeAngle(ar.getGunHeading() ));
//            System.out.println("now: "+ar.getVelocity() +","+RoboMath.normalRelativeAngle(ar.getHeading() ));
//            dbg();
            
            this.him = AxeBot.getIt().getMyTarget();
            this.pmData = VectorPMGun.popPmData();  
            myRobot.addCustomEvent(this);
        }

    }

    public long getExpectedTimeOfImpact() {
        return expectedTimeOfImpact;
    }
    public double getTargetDist() {
        return targetDist;
    }
    public String getTargetName() {
        return targetName;
    }
    public Bullet getBullet() {
        return bullet;
    }
    public int getAimMethod() {
        return aimMethod;
    }
    public boolean hitTarget() {
        return hitTarget;
    }
    public Point2D.Double getPoint() {
        return impactPt;
    }
    
    private static void updateStats(boolean hit, double dist){
    	int h = (hit)?1:0;
    	int i = getDistIndex(dist);
    	hitsRA[i] = RoboMath.rollingAverage((bullCount[i]<20)?bullCount[i]:20,hitsRA[i],h  );
    	hitsCount[i]+=h;
    	bullCount[i]++;
//    	System.out.println("Hits stats.["+i+"] bullCount:"+bullCount[i]+" hitsCount:"+hitsCount[i]+" raw avg:"+(((double)hitsCount[i]/(double)bullCount[i])*100D)+ " RA:"+(hitsRA[i]*100D ) );
    }
    
    public static double getHitAvg(double dist){
    	return hitsRA[getDistIndex(dist)]; 
    }
    
    private static int getDistIndex(double dist){
    	return (dist<200)?0:(dist<300)?1:(dist<400)?2:(dist<500)?3:(dist<600)?4:5;
    }
    private void dbg(){
    	
    	System.out.println(" time:" + AxeBot .getIt().getTime() );
    	System.out.println(" bullsPos:" + bulletPt);
    	System.out.println(" firePtPos:" + firePt);
    	System.out.println(" bullsAng:" + RoboMath.getNRDegrees( firePt,bulletPt ));
    	System.out.println(" bullsDist:" + firePt.distance(bulletPt  ));
    	
    }

    public boolean test() {

    	bulletPt.setLocation(bullet.getX(),bullet.getY()  );
        targetPt.setLocation(him.getX(),him.getY()   );
        double bulletDist = firePt.distance(bulletPt  );
        double targetDist = firePt.distance(targetPt   );
        double angle = (RoboMath.getNRDegrees( firePt,targetPt ));
        
//        dbg();
    	
        if (targetName.equals(bullet.getVictim())) {
            hitTarget = true;
            this.setImpactTime(AxeBot.getIt().getTime());
            myRobot.removeCustomEvent(this);
//            System.out.println(">>>>> acertou:"+bullet.getVictim());
            if(pmData!=null){
            pmData.hit(angle ,targetDist );
            pmData = null;
            }
            updateStats(hitTarget, targetDist );
            return true;
        }

        if (bullet.getVictim() != null) {
            myRobot.removeCustomEvent(this);
//            System.out.println(">>>>> acertou outro:"+bullet.getVictim()+" targetName"+targetName );
        }

        
        
        
        
        if(Math.abs(bulletDist - targetDist )<=(bullet.getVelocity()/2D)){
        	if(pmData!=null){
                pmData.hit(angle ,targetDist );
                pmData = null;
            }
        }
        
        if(((targetDist+30) - (bulletDist-bullet.getVelocity() )<0) && him.isAlive()  ){
        	hitTarget = false;
            myRobot.removeCustomEvent(this);
//        	System.out.println(">>>>> passou... "+bullet.getVictim()+" targetName"+targetName );
        	updateStats(hitTarget, targetDist );
        	return true;
        }

        if (!bullet.isActive() && him.isAlive()) {
        	
        	if(AxeBot.getIt().getField().contains(bulletPt ) ){
        		
                myRobot.removeCustomEvent(this);
//                System.out.println(">>>>> acertou bullet!..."+targetName+" bulletPt:"+bulletPt);
                
        		
        	}else{
        		hitTarget = false;
                myRobot.removeCustomEvent(this);
//                System.out.println(">>>>> errou..."+targetName+" bulletPt:"+bulletPt);
                updateStats(hitTarget, targetDist );
                return true;
        		
        	}
        		
            
        }

        return false;
    }
    /**
     * @return
     */
    public double getImpactTime() {
        return impactTime;
    }

    /**
     * @param d
     */
    public void setImpactTime(double d) {
        impactTime = d;
    }

    /**
     * @return
     */
    public AxeVector getMeToTarg() {
        return meToTarg;
    }

    /**
     * @return
     */
    public double getFacingAngle() {
        return facingAngle;
    }

    /**
     * @param d
     */
    public void setFacingAngle(double d) {
        facingAngle = d;
    }

    /**
     * @return
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * @return
     */
    public AxeGunner getGun() {
        return gun;
    }

}
