/*
 * Created on 2004-10-9
 */
package tide;

/**
 * this event occurred when one of your bullets hits another robot. 
 *
 *  @author xiemin
 */
public class BulletHitEvent extends Event
{
	//the power of the bullet.
	private double power;
	//the x position of the bullet.
	private double x;
	//the y position of the bullet.
	private double y;
	//the name of the robot you hit.
	private String name;
	
	/**
	 * create a new BulletHitEvent.
	 * @param event robocode's BulletHitEvent
	 */
	public BulletHitEvent(robocode.BulletHitEvent event)
	{
		super(event);
		this.name = event.getName();
		this.power = event.getBullet().getPower();
		this.x = event.getBullet().getX();
		this.y = event.getBullet().getY();
	}
	
	/**
	 * Return the power of the bullet.
	 */
	public double getPower()
	{
		 return power;
	}
	
	/**
	 * Return the x position of the bullet.
	 */
	public double getX()
	{
		 return x;
	}

	/**
	 * Return the y position of the bullet.
	 */
	public double getY()
	{
		 return y;
	}

	/**
	 * Return the name of the robot you hit.
	 */
	public String getName()
	{
		 return name;
	}
	
}







