/*
 * Created on 2004-9-27
 */
package tide.util;

import java.util.HashMap;
import java.util.Map;

import tide.pear.Pear;

/**
 * Bot Info Manager use to manage all bot's infos in a round.
 * You can get the enemy's infos in any time in current round.
 * You also can get mybot's info relative to a certain enemy.
 * @author iiley(Chen Jing)
 */
public class BotInfoManager {
	private Map map;
	
	public BotInfoManager(){
		map = new HashMap();
	}
	
	/**
	 * Add a bot info for time
	 * @param time the time of the info
	 * @param info
	 */
	public void addInfo(long time, BotInfo info){
		BotInfoList list = (BotInfoList)map.get(info.getName());
		if(list == null){
			list = new BotInfoList();
			map.put(info.getName(), list);
		}
		list.addInfo(time, info);
	}
	
	/**
	 * get a botinfo in certain time,if there is not,return null
	 * @param botName bot's name
	 * @param time
	 * @return a botinfo in certain time,if there is not,return null
	 */
	public BotInfo getInfo(String botName, long time){
		BotInfoList list = (BotInfoList)map.get(botName);
		if(list != null){
			return list.getInfo(time);
		}else{
			return null;
		}
	}
	
	/**
	 * get a botinfo in certain time,if there is not,return a empty info,not a null
	 * @param botName bot's name
	 * @param time
	 * @return a botinfo in certain time,if there is not,return a empty info,not a null
	 */
	public BotInfo getInfoMustHaveOne(String botName, long time){
		BotInfoList list = (BotInfoList)map.get(botName);
		if(list != null){
			return list.getInfoMustHaveOne(time);
		}else{
			//Pear.log("empty info : " + botName+","+time);
			return new BotInfo();
		}
	}
	
	/**
	 * return the bot fired a bullet's power in certain time
	 * if the bot not fired,the power is 0
	 * @param botName 
	 * @param time fire time
	 * @return the power of bot fired in certain time,if not fired,return 0
	 */
	public double firedPower(String botName, long time){
		double power = getInfoMustHaveOne(botName, time).getEnergy()
			- getInfoMustHaveOne(botName, time + 1).getEnergy();
		if(power>0d && power<=3d){
			return power;
		}else{
			return 0d;
		}
	}
	
	/**
	 * clear all infos
	 */
	public void clear(){
		map.clear();
	}
}
