/*
 * Created on 2004-10-8
 */
package tide.util;

import java.awt.geom.Point2D;

import tide.RobotConsole;
import tide.ScannedRobotEvent;

/**
 * Enemy Info,contains a certain enemy's info relative to mybot
 * @author iiley(Chen Jing)
 */
public class EnemyInfo extends BotInfo {

	public EnemyInfo(RobotConsole robot, ScannedRobotEvent e){
		time = e.getTime();
		
		name = e.getName();
		
		energy = e.getEnergy();
		
		absBearing = MathUtils.heading(robot.getX(), robot.getY(),
				e.getX(), e.getY());
		
		velocity = e.getVelocity();
		
		distance  = Point2D.distance(robot.getX(), robot.getY(),
				e.getX(), e.getY());
		
    	heading = MathUtils.anglePI(e.getHeading());
		
		location.setLocation(e.getX(), e.getY());

		leaveVelocity = e.getVelocity()*Math.sin(e.getHeading()-absBearing);
		if(leaveVelocity > 0){
			direction = 1;
		}else if(leaveVelocity<0){
			direction = -1;
		}
		
		closeVelocity = e.getVelocity()*Math.cos(e.getHeading()-absBearing);
	}
	
}
