/*
 * Created on 2004-9-30
 */
package tide.util; 


/**
 * This class provide some useful tool method.
 * 
 * @author xiemin
 */
public class Utils
{
	/**
	 * Transform a heading in the rococode reference frame 
	 * to Descartes reference frame.
	 * @param heading the heading will be transformed.
	 * @return the heading in the Descartes reference frame.
	 */
	public static double transform(double heading)
	{
		return MathUtils.angleDoublePI(-heading+Math.PI/2);
	}

	/**
	 * return the velocity of a bullet with the power.
	 * @param power bullet's power
	 * @return the velocity of a bullet with the power.
	 */
	public static double bulletVelocity(double power){
		return 20d-3d*power;
	}
	
	public static double bulletDamage(double power){
		double destory = power*4d;
		if(power > 1d){
			destory += (power - 1d)*2d;
		}
		return destory;
	}

	/**
	 * Return the index of the max value in the array.
	 * @param buffer the array.
	 * @return the index of the max value in the array.
	 */
	public static int maxValueIndex(float[] buffer){
		int index = 0;
		for(int i=1; i<buffer.length; i++){
			if(buffer[i] > buffer[index]){
				index = i;
			}
		}
		return index;
	}
	
}


