package lucasslf.utility;

import java.util.ArrayList;

public class LimitedList<E> extends ArrayList<E> {
	private int maxSize;

	public LimitedList(int maxSize) {
		super();
		this.maxSize = maxSize;
	}
	
	
	@Override
	public boolean add(E e) {
		try{
			super.add(0,e);
			while(this.size()>maxSize){
				remove(this.size()-1);
			}
			return true;
		}catch(Exception ex){
			return false;
		}
		
	}
	
}
