
package sgp;
import robocode.*;

public class SleepingGoat extends AdvancedRobot
{
	private double radarTurnAngleRadians = Math.PI;
	private double gunTurnAngleRadians = 0.0;
	private double turnAngleRadians = 0;
	private long lastScannedTime = -1;
	private double hVelocity = 0.0;
	
	/**
	 * The behaviour
	 */
	public void run()
	{
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		while (true)
		{				
			if (getDistanceRemaining() == 0)
			{	
				setAhead((Math.round(Math.random()) * 2 - 1) * 160);
			}
	
			setTurnRightRadians(turnAngleRadians);

			setTurnGunRightRadians(gunTurnAngleRadians);
			setTurnRadarRightRadians(radarTurnAngleRadians);
			radarTurnAngleRadians = Math.PI;

			fire(2.0);
		}
	}

	public void onScannedRobot(ScannedRobotEvent event) 
	{
		lastScannedTime = getTime();
		
		double abs_bearing = event.getBearingRadians() + getHeadingRadians();
		double relativeHeading = event.getHeadingRadians() - abs_bearing;
		//double hVelocity = event.getVelocity() * Math.sin(relativeHeading);
		
		hVelocity = (1.0/60.0) * event.getVelocity() * Math.sin(relativeHeading) + (59.0/60.0) * hVelocity;

		//track target
		gunTurnAngleRadians = Math.asin(Math.sin(abs_bearing - getGunHeadingRadians() + Math.asin(hVelocity / (20-3*2.0))));

		//move radar in the correct direction
		radarTurnAngleRadians = Math.asin(Math.sin(hVelocity / event.getDistance() + abs_bearing - getRadarHeadingRadians()));
		
		//turn robot
		turnAngleRadians = event.getBearingRadians() + (400*Math.PI/2.0)/event.getDistance();

	}
}
