package asd.gun.neuralib;

/**
 *
 * Current code size of these file is 158 and whole library is 591
 *
 * can be around 500 if you don't use momentum, bias check comment to see shrinking options
 *
 * If you want to use IO functions just uncomment the method init() in both files
 * to load use (nn=(NeuralNetwork)ois.readObject()).init();
 * codesize will be 657
 *
 * NeuralNetworkFloat files are half size of the double version
 *
 * if you have any questions, comment, bug report, or modification please e-mail me at synnalagma@hotmail.com
 *
 * These library is under LGPL license (you can use it whithout publishing the code, but must publish modification you make to this code) and is provided "as is" whithout any warranty
 *
 * @author Synnalagma
 * @version 1.2
 *
 * version history :
 *   0.9 first release
 *   1.0 shrinked to code size 173
 *   1.2 codesize 158 changed some code
 *
 * Next :
 *	 your propositions
 */
public class NeuralNetwork implements java.io.Serializable {
	/**Holds our layers
	 */
	private NeuronLayer[] layers;

	/**
	 * Creates a new NeuralNetwork object using an int array to describe the network
	 * the network structure for exemple: {5,3,2,1} provide 5 input, first hidden layer with 3 nodes, second hidden layer with 2 nodes and one output
	 * you can use any structure that can be sumarize by an int array (no limitation as I know)
	 * @param network the network structure
	 */
	public NeuralNetwork(int[] network) {
		layers = new NeuronLayer[network.length - 1];
		
		for(int i = 0; i < this.layers.length; i++) {
			layers[i] = new NeuronLayer(network[i], network[i + 1]);
		}
	}
	
	 
	/**
	 * get the output for the input
	 *
	 * @param input input as a double array
	 *
	 * @return the result of the neural network
	 */
	public double[] forwardPass(double[] input) {
		
		for(int i = 0; i < this.layers.length; i++) {
			input = layers[i].getOutput(input);
		}
		return input;
	}
	
	/**
	 * train the network withe exemple :<input, output>
	 *
	 * doesn't return the error value to shrink a little the codesize
	 *
	 * uncomment to get the error
	 *
	 * @param input the input 
	 * @param output the expected output
	 */
	public void train(double[] input, double[] output) {
		//double[] out = forwardPass(input);
		//double error=0;
		input = this.forwardPass(input);
		for(int i = 0; i < input.length; i++) {
			//error +=(output[i]-out[i]);
			//out[i] = (output[i] - out[i]) * out[i] * (1 - out[i]);
			input[i] = (output[i] - input[i]) * input[i] * (1 - input[i]);
		}
		
		for(int i = this.layers.length - 1; i > -1; i--) {
			input = layers[i].propagate(input);
		}
		//return error;
	}
	////////////////////////////////////////////////////////////////////////////
	//// IO FUNCTIONS
	////////////////////////////////////////////////////////////////////////////

 	/** Init the unsaved data of layers
	 * Important to call it after readObject()
	 */
/*	 public void init(){
	 	for(int i=0;i<layers.length;i++){
			layers[i].init();
		}
	 }*/

}
