package sgp;
import robocode.*;
import java.util.*;

/**
 * Intercept - a class by Simon Parker
 */

public class Intercept
{
	public static int LINEAR = 0;
	public static int CIRCULAR = 1;
	public static int JIGGLE = 2;
	public static int PATTERN = 3;

	public Coordinate impactPoint = new Coordinate(0,0);
	public double bulletHeading_deg;

	protected Coordinate bulletStartingPoint = new Coordinate();
	protected Coordinate targetStartingPoint = new Coordinate();
	public double targetHeading;
	public double targetVelocity;
	public double bulletPower;
	public double angleThreshold;
	public double distance;

	public double targetRadius = 20;

	protected double impactTime;

	public Intercept(double tRadius)
	{
		targetRadius = tRadius;
	}

	public Intercept()
	{
		targetRadius = 20;
	}


	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		bulletStartingPoint.x = xb;
		bulletStartingPoint.y = yb;
		targetStartingPoint.x = xt;
		targetStartingPoint.y = yt;

		targetHeading = tHeading;
		targetVelocity = vt;
		bulletPower = bPower;
		double vb = 20-3*bulletPower;

		double dX = xt - xb;
		double dY = yt - yb;
		double r = Math.sqrt(dX*dX + dY*dY);
		double K = vt/vb*(dX*Math.cos(Math.toRadians(targetHeading)) - dY*Math.sin(Math.toRadians(targetHeading)));
		bulletHeading_deg = 180.0 - (Math.toRadians(Math.asin(K/r)) ) - (Math.toRadians(Math.atan2(dX,-dY)));

		double A = vb*Math.cos(Math.toRadians(bulletHeading_deg)) - vt*Math.cos(Math.toRadians(targetHeading));
		double B = vb*Math.sin(Math.toRadians(bulletHeading_deg)) - vt*Math.sin(Math.toRadians(targetHeading));
		impactTime = (dY*A+dX*B)/(A*A+B*B);

		impactPoint.x = xb + vb*Math.sin(Math.toRadians(bulletHeading_deg))*impactTime;
		impactPoint.y = yb + vb*Math.cos(Math.toRadians(bulletHeading_deg))*impactTime;

		calculate();
	}

	public void calculate
	(
		Coordinate bulletStartPosition,
		Coordinate targetPosition,
		double tHeading,
		double vt,
		double bPower,
		double angularVelocity_deg_per_sec
	)
	{
		calculate
		(
			bulletStartPosition.x,
			bulletStartPosition.y,
			targetPosition.x,
			targetPosition.y,
			tHeading, vt, bPower, angularVelocity_deg_per_sec
		);
	}

	protected void init()
	{
	}

	protected void calculate()
	{
		distance = bulletStartingPoint.distanceFrom(targetStartingPoint);
		angleThreshold = Math.toDegrees(Math.atan(targetRadius/distance));
	}


}

