package ags.polished;

import static robocode.util.Utils.normalRelativeAngle;

import ags.rougedc.base.Rules;
import ags.rougedc.base.actors.MovementActor;
import ags.rougedc.robots.*;
//import ags.rougedc.waves.EnemyWaveManager;
import ags.utils.points.AbsolutePoint;
import ags.utils.points.RelativePoint;

public class RougeMirror {
    private final Rules rules;
    private final StatusRobot status;
    private final EnemyList enemies;
    
    public RougeMirror(Rules rules, StatusRobot status, EnemyList enemies) {
    	this.rules = rules;
    	this.status = status;
    	this.enemies = enemies;
    }
    
    public void run(MovementActor movementActor) {
    	final EnemyRobot target = enemies.getTarget();
    	if (target == null)
    		return;
    	
    	final AbsolutePoint enemypoint = target.getLocation();
    	final AbsolutePoint goalpoint = AbsolutePoint.fromXY(rules.BATTLEFIELD_WIDTH-enemypoint.x, rules.BATTLEFIELD_HEIGHT-enemypoint.y);
    	
        final RelativePoint relgoal = RelativePoint.fromPP(status.getLocation(), goalpoint);
        
        double turn = normalRelativeAngle(relgoal.direction - status.getVelocity().direction);
        
        // Back as front
        final int invert;
        if (Math.abs(turn) > Math.PI/2) {
            turn = normalRelativeAngle(turn + Math.PI);
            invert = -1;
        } else {
            invert = 1;
        }
    	
    	movementActor.setMove(relgoal.magnitude*invert);
        movementActor.setTurnBody(turn);
    }
}
