var turningGun = false;

this.properties = {
	version: "1.1",
	description: "JavaScript/Rhino/SLIME Proof-of-Concept Robot",
	"author.name": "David P. Caldwell <david@davidpcaldwell.com>",
	"java.source.included": false
}

this.run = function() {
	while(true) {
		this.ahead(100);
		if (!turningGun) this.turnGunRight(360);
		this.back(100);
		if (!turningGun) this.turnGunRight(360);
	}
};

this.onScannedRobot = function(e) {
	turningGun = true;
	var aim = this.heading + e.getBearing();
	while (aim < 0) aim += 360;
	while (aim > 360) aim -= 360;
	this.turnGunRight(aim - this.gunHeading);
	this.fire(1);
	turningGun = false;
}

this.onHitByBullet = function(e) {
	this.turnLeft(90 - e.getBearing());
}

this.onRoundEnded = function(e) {
	turningGun = false;
}
