package jwst.Enemies;

import robocode.*;
import java.awt.geom.Point2D;
import jwst.DAD.Targeting.*;
import jwst.DAD.Movement.*;

/***************************************************************************************************
 * This class extends the Enemy class by using an AdvancedRobot in order to function with several
 * more enemy functions. Helps us in terms of using wavesurfing, guess factor targeting and
 * AntiGravity.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * 
 * Credit: Mr. Peck
 * 
 ****************************************************************************************************/
public class AdvancedEnemy extends Enemy
{
    /**
     * previous energy
     */
    public double pEnergy; 
    
    /**
     * previous velocity
     */
    public double pVelocity; 
    
    /**
     * previous x coordinate
     */
    public double pX;
    
    /**
     * previous y coordinate
     */
    
    public double pY;
    /**
     * previous location
     */
    public Point2D.Double pLocation;
    
    /**
     * the last time that the enemy's update method was called 
     */
    public long lastUpdated;
    
    //each advanced enemy holds its own guess factor targeting gun and waverider tank
    //because in each GFT gun and waverider there are arrays that are specific to each
    //robot. we don't want to mix information from different enemies.
    /**
     * the enemy's gun
     */
    public GuessFactorTargeting gun;
    
    /**
     * the enemy's tank
     */
    public WaveRider tank;
    
    //////////////////////////////////////constructors//////////////////////////////////////////////
    /**
     * @param robot - this is used for 1v1 because you don't need to differentiate between 
     * robots in 1v1
     */
    public AdvancedEnemy(AdvancedRobot robot)
    {
        super();
        reset();
        gun = new GuessFactorTargeting(robot);
        tank = new WaveRider(robot);
    }
    
    /**
     * This constructor is called in melee when it's down to 1v1 and all the other 
     * robots have died except ours and one other.
     * 
     * 
     * @param e - this ScannedRobotEvent helps us lock onto one target
     * @param robot - advanced robot that we initially at the start
     */
    public AdvancedEnemy(ScannedRobotEvent e, AdvancedRobot robot)
    {
        super();
        reset();
        update(e, robot);
        gun = new GuessFactorTargeting(robot);
        tank = new WaveRider(robot);
    }

    /**
     * Figures out whether or not a bullet was fired.
     * 
     * @return true if a bullet was fired, false if not
     */
    public boolean firedBullet() 
    {
        return (getEnergyChange() <= 3.0 && getEnergyChange() >= 0.1);
    }

    /**
     * Gets the energy change between now and last updated.
     * 
     * @return change in energy
     */
    public double getEnergyChange() 
    {
        return pEnergy - energy;
    }
    
    /**
     *  it updates, and sets the "previous" variables to the information that we 
     *  just got about the enemy robot
     */
    public void update( ScannedRobotEvent e, AdvancedRobot robot )
    {
        pEnergy = energy;
        pVelocity = velocity;
        pLocation = location;
        pX = x;
        pY = y;
        lastUpdated = e.getTime();
        super.update( e, robot );
    }

    /**
     * resets all the variables at the moment our robot is first initialized
     */
    public void reset()
    {
        pEnergy = 0;
        pVelocity = 0;
        pX = 0;
        pY = 0;
        super.reset();
    }
    
    /**
     * used to debug, and prints out the variable name and value for us to try and fix any errors
     */
    public String toString()
    {
        System.out.println("name: " + name);
        System.out.println("bearing: " + bearing);
        System.out.println("absBearing: " + absBearing);
        System.out.println("distance: " + distance);
        System.out.println("energy: " + energy);
        System.out.println("heading: " + heading);
        System.out.println("x: " + x);
        System.out.println("y: " + y);
        System.out.println("pVelocity: " + pVelocity);
        System.out.println("pX: " + pLocation.getX());
        System.out.println("pY: " + pLocation.getY());
        return "**********************************";
    }
}