package simonton.guns.singleTick;

public class Speculation extends Pattern {
	private short[] past;
	private short[] future = new short[1024];
	int pastLength;
	int pastHashCode;
	private int pastStart;
	private int speculationLength;
	private int speculationStart;

	public Speculation(int targetLength) {
		assert targetLength >= 0;
		assert targetLength <= Short.MAX_VALUE;

		past = new short[targetLength];
	}

	public void reset() {
		hashCode = pastHashCode;
		length = (short) pastLength;
		speculationLength = 0;
		speculationStart = 0;
	}

	public void record(short code) {
		if (pastLength < past.length) {
			assert pastStart == 0;
			past[pastLength++] = code;
		} else {
			assert pastLength == past.length;
			pastHashCode ^= past[pastStart];
			pastHashCode = (pastHashCode << 1) | (pastHashCode >>> 31);
			past[pastStart] = code;
			pastStart = (pastStart + 1) % pastLength;
		}
		int shift = (pastLength - 1) % 32;
		pastHashCode ^= (code >>> shift) | (code << (32 - shift));
		reset();
	}

	public void speculate(short code) {
		if (length < past.length) {
			++length;
		} else {
			hashCode ^= getCode(0);
			hashCode = (hashCode << 1) | (hashCode >>> 31);
			++speculationStart;
		}
		future[speculationLength] = code;
		++speculationLength;
		int shift = (length - 1) % 32;
		hashCode ^= (code >>> shift) | (code << (32 - shift));
	}

	@Override
	public short getCode(int i) {
		assert i >= 0;
		assert i < length;
		
		i += speculationStart;
		if (i < pastLength) {
			return past[(pastStart + i) % past.length];
		}
		return future[i - pastLength];
	}

	@Override
	public Pattern subPattern(short subLength) {
		assert subLength >= 0;
		assert subLength <= length;

		int start = length - subLength;
		Pattern subPattern = new SubSpeculation(start, subLength);

		int subHashCode = hashCode;
		for (int i = 0; i < start; ++i) {
			subHashCode ^= getCode(i);
			subHashCode = (subHashCode << 1) | (subHashCode >>> 31);
		}
		subPattern.hashCode = subHashCode;

		return subPattern;
	}

	class SubSpeculation extends Pattern {
		int start;

		public SubSpeculation(int start, short length) {
			this.start = start;
			this.length = length;
		}

		@Override
		public short getCode(int i) {
			assert i >= 0;
			assert i < length;
			return Speculation.this.getCode(start + i);
		}

		@Override
		public Pattern subPattern(short subLength) {
			assert subLength >= 0;
			assert subLength <= length;

			int subStart = length - subLength;
			Pattern subPattern = new SubSpeculation(start + subStart, subLength);

			int subHashCode = hashCode;
			for (int i = 0; i < subStart; ++i) {
				subHashCode ^= getCode(i);
				subHashCode = (subHashCode << 1) | (subHashCode >>> 31);
			}
			subPattern.hashCode = subHashCode;

			return subPattern;
		}
	}

	public static void main(String[] args) {
		Speculation spec = new Speculation(3);
		Pattern p = spec.subPattern((short) 0);
		spec.record((short) 0);
		p = spec.subPattern((short) 1);
		p = p.subPattern((short) 0);
		spec.speculate((short) 1);
		spec.speculate((short) 2);
		spec.speculate((short) 3);
		p = spec.subPattern((short) 2);
		p = p.subPattern((short) 1);
		p = p.subPattern((short) 0);
		spec.record((short) 1);
		p = spec.subPattern((short) 2);
		p = p.subPattern((short) 1);
		p = p.subPattern((short) 0);
		spec.speculate((short) 2);
		spec.speculate((short) 3);
		p = spec.subPattern((short) 3);
		p = p.subPattern((short) 2);
		p = p.subPattern((short) 1);
		p = p.subPattern((short) 0);
		spec.record((short) 2);
		spec.record((short) 3);
		spec.record((short) 4);
		spec.record((short) 5);
		spec.record((short) 6);
		spec.record((short) 7);
		spec.speculate((short) 8);
		spec.speculate((short) 9);
		spec.speculate((short) 10);
		spec.speculate((short) 11);
		p = p.subPattern((short) 3);
		p = p.subPattern((short) 2);
		p = p.subPattern((short) 1);
		p = p.subPattern((short) 0);
	}
}
