package simonton.movements;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import simonton.core.Wave;
import simonton.utils.Util;

public class EnemyHitsWaveMachine extends WaveMachine {

	private Map<Wave, Double> waveDangers = new HashMap<Wave, Double>();
	private double[][] dangers;
	private double[][] flipDangers;
	private double lastLateralVelocity;
	private double dangerDecay;
	private int paddedBins;
	private int binPadding;
	private int gfZero;
	private int bins;

	public EnemyHitsWaveMachine(double dangerDecay, double weight) {
		super(weight);
		this.dangerDecay = dangerDecay;
	}

	@Override
	public void run() {
		if (waveDangers != null) {
			waveDangers.clear();
		}
	}

	@Override
	public double[] getDangers(Wave wave, int bins, int binPadding) {
		if (dangers == null) {
			paddedBins = bins + 2 * binPadding;
			dangers = new double[9][paddedBins];
			flipDangers = new double[9][paddedBins];
			gfZero = (bins + 1) / 2;
			this.bins = bins;
			this.binPadding = binPadding;
		} else {
			assert dangers[0].length == bins + 2 * binPadding;
		}
		assert wave.fireTime == getTime();
		if (lastLateralVelocity >= 0) {
			return dangers[(int) (lastLateralVelocity + .5)];
		}
		return flipDangers[(int) (-lastLateralVelocity + .5)];
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		super.onScannedRobot(e);
		if (Util.addedEnemyWave != null) {
			waveDangers.put(Util.addedEnemyWave, lastLateralVelocity);
		}
		if (Util.deletedEnemyWave != null) {
			waveDangers.remove(Util.deletedEnemyWave);
		}
		lastLateralVelocity = getVelocity()
				* Util.sin((int) (e.getBearing() + .5));
	}

	@Override
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		super.onBulletHitBullet(e);
		logHit(e.getHitBullet());
	}

	@Override
	public void onHitByBullet(HitByBulletEvent e) {
		super.onHitByBullet(e);
		logHit(e.getBullet());
	}

	private void logHit(Bullet bullet) {
		Point2D.Double location = new Point2D.Double(bullet.getX(), bullet
				.getY());
		for (Wave enemyWave : Util.enemyWaves) {
			if (enemyWave.equals(bullet)) {
				int factor;
				int segment;
				double[] dangers;
				double[] flipDangers;
				double latV = waveDangers.get(enemyWave);
				if (latV >= 0) {
					segment = (int) (latV + .5);
					factor = enemyWave.getFactorIndex(location, gfZero,
							binPadding);
				} else {
					segment = (int) (-latV + .5);
					factor = paddedBins
							- 1
							- enemyWave.getFactorIndex(location, gfZero,
									binPadding);
				}
				int diff;
				dangers = this.dangers[segment];
				flipDangers = this.flipDangers[segment];
				for (int i = bins; --i >= 0;) {
					int paddedPos = i + binPadding;
					diff = paddedPos - factor;
					dangers[paddedPos] = flipDangers[paddedBins - 1 - paddedPos] = Math
							.max(weight / (1 + diff * diff), dangers[paddedPos]
									* dangerDecay);
				}
				Util.enemyWaves.remove(enemyWave);
				return;
			}
		}
		Util.log("NO ENEMY WAVE FOUND RESPONIBLE FOR BULLET HIT");
	}
}
