package kawigi.sbf;
import robocode.*;
import java.awt.geom.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;
import java.util.zip.*;
/**
 * Barracuda - the third "FloodMini" - with an angular-based gun with similar segments to FloodMini.
 */
public class Barracuda extends AdvancedRobot
{
	static double currentDirection;
	static double currentEnergy;
	static double currentVBound;
	static int distanceindex;
	long nextTime;
	static double[] benefit, penalty;
	static double[][][] angles;
	private Vector ovbullets = new Vector();
	static int direction = 1, rounds;
	static String name;
	static Rectangle2D fieldrect;
	
	public boolean out(double x, double y, double c)
	{
		return !fieldrect.contains(x*c+getX(), y*c+getY());
	}

	public void run()
	{
		rounds++;
		fieldrect = new Rectangle2D.Double(18D, 18D, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D);
		currentEnergy = 100;
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		//setColors(Color.blue, null, Color.blue);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do
		{
			setMaxVelocity(currentVBound);
			double heading;
			if (out(Math.sin(heading = getHeadingRadians()),Math.cos(heading),currentDirection))
				currentDirection = -currentDirection;
			setAhead(currentDirection);
			execute();
		}
		while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if (name == null)
		{
			name = e.getName();
			try
			{
				ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(name))));
				benefit = (double[])in.readObject();
				penalty = (double[])in.readObject();
				angles = (double[][][])in.readObject();
				rounds = ((int[])in.readObject())[0]/2;
				in.close();
			}
			catch (Exception ex)
			{
				angles = new double[2][5][25];
				benefit = new double[25];
				penalty = new double[25];
			}
		}
		setTurnRadarLeft(getRadarTurnRemaining());
		double distance;
		distanceindex = (int)((distance = e.getDistance())/50);
		long time = getTime();
		double denergy;
		if ((denergy = currentEnergy-e.getEnergy()) > .09 && denergy <= 3)
		{
			benefit[distanceindex] += denergy;
			if (time >= nextTime)
			{
				currentVBound = Math.random()*20;
				currentDirection = (Math.random() < .5)?-40:40;
				nextTime = time+(long)(distance/(40-6*denergy));
			}
		}
		currentEnergy = e.getEnergy();
		double rel;
		
		double absbearing;
		double eheading;
		double evel;
		double latvel = Math.sin((eheading = e.getHeadingRadians())-(absbearing = getHeadingRadians() + e.getBearingRadians()))*(evel = e.getVelocity());
		double mindist = findDistanceBracket();
		
		if ((distance < mindist && distance > mindist-120 && (distanceFromCorner()>200 || distanceFromCorner() > distance)) || out(Math.sin(-absbearing), Math.cos(-absbearing), 30))
			rel = Math.PI/2;
		else if ((distance > mindist || distanceFromCorner() < 200) == currentDirection > 0)
			rel = Math.PI/3;
		else
			rel = 2*Math.PI/3;
		setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(e.getBearingRadians()-rel));
		if (latvel != 0)
			direction = (latvel < 0)?-1:1;
		
		//my angular gun:
		double x = getX()+Math.sin(absbearing)*distance;
		double y = getY()+Math.cos(absbearing)*distance;
		
		int latv = (int)Math.abs(latvel/2);
		int wallrel=0;
		if (!fieldrect.contains(x+10*Math.sin(eheading)*evel, y+10*Math.cos(eheading)*evel))
			wallrel = 1;
		
		int i=0;
		while (i < ovbullets.size())
		{
			MiniBullet2 b = (MiniBullet2)ovbullets.elementAt(i);
			double angle;
			if (!Double.isNaN(angle = b.updateEnemy(x, y, time)))
			{
				double[] pointer;
				int ind;
				int factor;
				//sorry this is super-ugly, had to save codesize somewhere...
				//just so you know, this really says:
				//factor in 'angle' as into angles[b.wallrel][b.latspeed][b.dindex] as a rolling average with factor rounds*20 (or 200 if rounds > 10)
				(pointer = angles[b.wallrel][b.latspeed])[ind = b.dindex] = (pointer[ind]*((factor = Math.min(rounds*10, 200))-1) + angle)/factor;
				ovbullets.removeElementAt(i);
			}
			else
				i++;
		}
		
		double power = Math.min(Math.min(Math.min(getEnergy()*.2, currentEnergy*.25), 1500/distance), 3);
		//the 0.81434 is asin(8/11);
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()+Math.asin(8/(20-power*3))/0.81434*angles[wallrel][latv][distanceindex]*direction));
			
		if (getGunHeat() == 0)
		{		
			ovbullets.addElement(new MiniBullet2(getX(), getY(), direction, latv, distanceindex, wallrel, x, y, absbearing, time+1));
			//waitFor(new GunTurnCompleteCondition(this));
			penalty[distanceindex] += power;
			setFire(power);
		}
	}

	private double distanceFromCorner()
	{
		double min = Double.POSITIVE_INFINITY;
		int i=0;
		do
		{
			min = Math.min(min, Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight()));
			i++;
		}
		while (i < 4);
		return min;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		double power = e.getPower();
		currentEnergy += power*3;
		penalty[distanceindex] += Math.max(power*7, power*9-2);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		double power = e.getBullet().getPower();
		double damage;
		currentEnergy -= (damage = Math.max(4*power, 6*power-2));
		benefit[distanceindex] += damage+power*3;
	}
	
	public double findDistanceBracket()
	{
		int bestindex;
		int i = bestindex = 4;
		do
		{
			if (findBenefit2(i) > findBenefit2(bestindex))
				bestindex = i;
			i++;
		}
		while (i <= 12);
		return bestindex*50+85;
	}
	
	public double findBenefit2(int index)
	{
		return 2*findBenefit(index)+findBenefit(index-1)+findBenefit(index+1);
	}
	
	public double findBenefit(int index)
	{
		return (benefit[index]-penalty[index])/(benefit[index]+penalty[index]);
	}
	
	public void onWin(WinEvent e)
	{
		try
		{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(name))));
			out.writeObject(benefit);
			out.writeObject(penalty);
			out.writeObject(angles);
			out.writeObject(new int[]{rounds});
			out.close();
		}
		catch (IOException ex)
		{
		}
	}
}