package axeBots.okami;
import robocode.*;

import java.awt.Shape;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import axeBots.data.BotData;
import axeBots.data.StaticDataCenter;

import axeBots.AxeBot;
import axeBots.Okami;
import axeBots.gunner.AntiMirrorGun;
import axeBots.gunner.VectorPMGun;
import axeBots.util.*;
import axeBots.pilot.*;
import axeBots.pilot.waves.EnemyWave;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeTarget implements Cloneable {
    private double heat;
    public static final int MIRROR_LIST_MAX_SIZE= 60;
    private double[] mirrorList= new double[MIRROR_LIST_MAX_SIZE];
    private int mirrorQt;
    //    private int mirrorInd;
    //    private double mirrorAmt;
    private double lastBulletPow;
    private Shape botShape= null;
    private Stratego stratego= null; //new Stratego();
    private String name;
    private String alvo= null;
    private double bearing;
    private double absbearing_rad;
    private int hitsOnARow= 0;
    //private double head;
    //private long ctime; //game time that the scan was produced
    //private double speed;
    private double x, y;
    private double distance;
    private boolean disabled;
    //private double changehead;
    //private double changeVel;

    private double phasis= 0;
    private double lastStop= 0;

    //private ScannedRobotEvent alvo = null; 
    private double maxX;
    private double maxY;
    private double acc;

    private double targetWidth;
    private double targetHeight;
    private double timeToHit;
    // private static final int maxAmostras= 2;

    private double headsDelta;
    private long timesDelta;
    private double velsDelta;
    private double lifesDelta;

    private double head;
    private long time;
    private double vel;
    private double life;

    private double headsSum;
    private double velsSum;

    //    private ArrayList heads= new double[maxAmostras];
    //    private ArrayList times= new long[maxAmostras];
    //    private ArrayList vels= new double[maxAmostras];
    //    private ArrayList lifes= new double[maxAmostras];

    //private double dists[]= new double[maxAmostras - 1];
    private ArrayList pos= new ArrayList();
    //private Vector interpolated= new Vector();

    //private AxeVector botPosRecorded[][]= new AxeVector[1][];

    //private ArrayList clock= new ArrayList();
    private int amostras= 0;
    //private int num= 0;
    private boolean isAlive= true;
    private int hitMe= 0;
    private int damage= 0;
    private PrintStream log= null;
    private double attackAngle;
    //private Point2D.Double shoudItBe= null;
    //private AxeVector adjustVec;
    private int points= 0;
    //private int totPoints= 0;

    private int historyMatch= 50;
	private double expectedLifeDiff= 0;
    private int maxHistMatch= 200;

    //private double mgun2step= Math.PI / 36;
    private int mgun2lim= 2;

    private int mgun2pos= 0;
    private int mgun2dir= 1;

    // private double mgun1step= Math.PI / 36;
    private int mgun1lim= 1;

    private int mgun1pos= 0;
    private int mgun1dir= 1;

    private double canHitMe= Double.NaN;
    private BulletTracker lastHit= null;

    private double deslocationSum= 0;
    private double deslocationSquaredSum= 0;

    private BotData botData= null;

    //    public synchronized int getTargetMisses() {
    //        return stratego.getTargetMisses();
    //    }

    //    public synchronized void resetTargetMisses() {
    //        stratego.resetTargetMisses();
    //    }

    public void fired() {
        //log.println(">>>>>>>>>>>>>>>>   HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+" aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());

        //stratego.fired(bt.getBullet().getPower());

        if (Math.abs(mgun1pos) >= mgun1lim)
            mgun1dir *= -1;
        mgun1pos += mgun1dir;

        //log.println("AxeTarget fired mgun2pos:"+mgun2pos+" mgun2dir:"+mgun2dir );

        if (mgun2dir < 0) {
            if (mgun2pos <= mgun2lim * mgun2dir)
                mgun2dir *= -1;
            else
                mgun2pos += mgun2dir;
        } else if (mgun2dir > 0) {
            if (mgun2pos >= mgun2lim * mgun2dir)
                mgun2dir *= -1;
            else
                mgun2pos += mgun2dir;
        }

        //if(Math.abs( mgun2pos) >= mgun2lim) mgun2dir *= -1;
        //mgun2pos += mgun2dir;

    }

    //private AdvancedRobot pai= null;
    public void setDuel(boolean d) {
        this.setAlvo(AxeBot.getIt().getName());
        stratego.setDuel(d);
    }

    //    public void killedMe() {
    //        stratego.setTotPts(2);
    //    }

    public void hitMe(double dam) {

        AxeBot me= AxeBot.getIt();
        hitMe++;
        damage += dam;
        this.setAlvo(me.getName());
        stratego.setEnemyHitedMe(me.getMoveStrat(), dam);
    }

    public int getHitMe() {
        return damage;
    }

    public void loose() {
        this.isAlive= false;
    }

    public void win() {
        //this.isAlive= false;
    }

    public void terminate() {
		log.println("  Data size:" + this.botData.getSamplesSize() );
        heat= 0;
        log.println(this.stratego.getPowerStats());

        if (isAlive) {
            stratego.setScore((AxeBot.getIt()).getTotBots());
            botData.getScorer().win();
        }

        log.println(botData.getScorer().toString());
        if (AxeBot.SAVE_DATA
            && (AxeBot.getIt().getRoundNum()
                == (AxeBot.getIt().getNumRounds() - 1))) {
            AxeFiles.cleanBotsFiles(name);
            stratego.saveData();
            botData.getGfHistory().save( this.getName()); 
            //((Musashi)AxeBot.getIt()).getMyPilot().save(this.getName());  
        }

    }

    //    public void saveInterpolated(DataOutputStream w) throws IOException {
    //
    //        
    //        int size= 3000;
    //        int sizeCont= 0;
    //
    //        if (AxeBot.getIt().getRoundNum()
    //            == (AxeBot.getIt().getNumRounds() - 1)) {
    //            //return;
    //            size = 0;
    //        }
    //
    //        AxeVector botRecs[][]= this.getInterpolated();
    //
    //        AxeVector vec= null;
    //        
    //		int start= botRecs.length;
    //
    //        //log.println("turnos a serem gravados:" + botRecs.length);
    //        for (int i= (botRecs.length - 1); i >= 0; i--) {
    //            sizeCont += botRecs[i].length;
    //            if (sizeCont < size) {
    //                start= i;
    //            } else {
    //                break;
    //            }
    //        }
    //        w.writeInt((botRecs.length - start));
    //        for (int i= start; i < botRecs.length; i++) {
    //            //log.println("turno:" + i + " tam:" + botRecs[i].length);
    //            w.writeInt(botRecs[i].length);
    //
    //            for (int j= 0; j < botRecs[i].length; j++) {
    //                vec= botRecs[i][j];
    //                //log.println("rec:" + i+" "+j+" "+botRecs[i][j]);
    //                w.writeChar((char)vec.getX());
    //                w.writeChar((char)vec.getY());
    //            }
    //        }
    //    }

    //    public void loadInterpolated(DataInputStream r) throws IOException {
    //
    //        try {
    //            int arraysize= r.readInt();
    //            this.botPosRecorded= new AxeVector[arraysize + 1][];
    //            log.println("turnos gravados:" + arraysize);
    //
    //            AxeVector vec= null;
    //            for (int i= 0; i < arraysize; i++) {
    //
    //                int size= r.readInt();
    //                this.botPosRecorded[i]= new AxeVector[size];
    //                log.println("turno:" + i + " size:" + size);
    //                for (int j= 0; j < size; j++) {
    //                    this.botPosRecorded[i][j]=
    //                        new AxeVector(
    //                            (double)r.readChar(),
    //                            (double)r.readChar());
    //                }
    //            }
    //        } catch (IOException e) {
    //            this.botPosRecorded= new AxeVector[1][];
    //            e.printStackTrace();
    //            throw new IOException("nao carregou interpolated data.");
    //        }
    //    }

    public double getAttackAngle() {
        return attackAngle;
    }

    public double getDistance() {
        return distance;
    }

    public Shape getBotShape() {

        return botShape;

    }

    private void setBotShape() {

        AxeBot me= AxeBot.getIt();

        double dx= me.getWidth();
        double dy= me.getHeight();

        Rectangle2D.Double botRect=
            new Rectangle2D.Double(
                this.pos().x - (dx / 2),
                this.pos().y - (dy / 2),
                dx,
                dy);

        botShape= botRect;

        //        me.out.println(
        //            this.getName() + " bot rect:" + botRect + " pos:" + this.pos());

        // Create a rotation transform of 30degrees CCW around
        // the the corner of the rectangle. 
        AffineTransform atx=
            AffineTransform.getRotateInstance(
                Math.toRadians(this.getHeading()),
                pos().x,
                pos().y);
        // Take the shape object and create a rotated version 
        botShape= atx.createTransformedShape(botShape);

    }

    /**Return the bearing (0 means our robot heading) in radians
     * Between 0-2PI.
     */
    public double getBearing() {
        return bearing;
    }

    public double getHeading() {
        return head;
    }

    public double getHeadToMe() {
        double ret= Math.toDegrees(this.getHeading());
        ret=
            RoboMath.normalRelativeAngle(
                (this.getVelocity() < 0) ? ret - 180 : ret);
        ret=
            RoboMath.normalRelativeAngle(
                ret - RoboMath.getang(this.pos(), AxeBot.getIt().pos()));
        return ret;
    }

    public double getHeadsDelta() {
        return this.headsDelta;
    }

    public double getAcceleration() {
        return this.velsDelta;
    }

    public double getAvgVel() {
        return this.velsSum / amostras;
    }

    public double getAvgHeads() {
        return this.headsDelta / amostras;
    }

    /**Return the absolute bearing (0 means Y axis) in radians
     * Between 0-2PI.
     */
    public double getAbsBearing() {
        return absbearing_rad;
    }

    public double getTimeToHit() {
        return timeToHit;
    }

    //    public int getAimStrat() {
    //        return stratego.getAimStrat();
    //    }

    //    public int newAimStrat(boolean vbon) {
    //        return stratego.newAimStrat(this,vbon);
    //    }

    //    public  int getPoints() {
    //        return stratego.getTotPts();
    //    }

    //    public String getStats() {
    //        String ret = "BOT: " + getName() + "\r\n" + stratego.getStats();
    //
    //        return ret;
    //    }

    public boolean isAlive() {
        return isAlive;
    }

    public boolean isIn(Shape s) {
        if (s.contains(this.getX(), this.getY())) {
            return true;
        } else {
            return false;
        }
    }

    public void dead(int pts) {

        stratego.setScore(pts);
        botData.getScorer().died();
        //log.println(this.getName()+"  dead "+pts); 
        isAlive= false;
    }

    public void setTimeToHit(double novo) {
        timeToHit= novo;
    }

    public void hit(BulletTracker bt) {
        this.lastHit= bt;

        this.incHitsOnARow();
        if (isAlive())
            stratego.hit(bt);
    }

    public void missed(BulletTracker bt) {

        this.decHitsOnARow();
        if (isAlive()) {
            stratego.missed(bt);
            //            AxeVector is= (AxeVector)interpolated.get(interpolated.size() - 1);
            //            shoudItBe= bt.getPoint();
            //            adjustVec=
            //                new AxeVector(
            //                    (shoudItBe.getX() - is.getX()),
            //                    (shoudItBe.getY() - is.getY()));
        }
    }

    public Point2D.Double pos() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Point2D.Double getPos(int atTime) {
        return botData.getPos(atTime);
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public String getName() {
        return name;
    }

    public double getLastEnergy() {
        return life;
    }

    public double getVelocity() {
        return vel;
    }

    public double getScanTime() {
        return time;
    }

    public Vector getAllPos() {
        return (Vector)pos.clone();
    }

    public AxeTarget(String nome, PrintStream inlog) {
        super();
        this.name= nome;
        log= inlog;
        stratego= new Stratego(nome, log);
    }

    public AxeTarget(String nome) {

        this(nome, null);

    }

    public AxeTarget(
        ScannedRobotEvent e,
        AdvancedRobot ft,
        PrintStream inlog) {
        this(e.getName(), inlog);
        botData= StaticDataCenter.logIn(name);
        stratego= new Stratego(name, log, this);
        if (ft != null) {
            maxX= ft.getBattleFieldWidth();
            maxY= ft.getBattleFieldHeight();
            targetWidth= ft.getWidth();
            targetHeight= ft.getHeight();
            //seta

            if (e != null)
                setScanned(e, ft);
        }

    }

    public double getLastLifeDiff() {
        if (amostras < 2)
            return 0;

        double sum= 0;

        if ((lastHit != null)
            && (Double.isNaN(lastHit.getImpactTime()))
            && (lastHit.getImpactTime() == time)) {
            sum= RoboMath.getBulletDamage(lastHit.getBullet().getPower());
        }

        return this.lifesDelta + sum;
    }

    public double getMoveAngle() {
        if (pos.size() < 2)
            return Double.NaN;
        AxeVector going= null;
        AxeVector now= (AxeVector)pos.get(pos.size() - 1);
        AxeVector test= null;
        double moveAngle= Double.NaN;
        double mod= 0;
        int cont= pos.size() - 1;
        while ((mod == 0) && (cont > 0)) {
            test= (AxeVector)pos.get(--cont);
            going= now.minus(test);
            mod= going.getRelativeModule();
        }

        if (mod != 0) {
            moveAngle= RoboMath.normalRelativeAngle(going.getRelativeTheta());
        }

        //        log.println(
        //            " getMoveAngle:"
        //                + moveAngle
        //                + " mod:"
        //                + mod
        //                + " size:"
        //                + pos.size()
        //                + " test pos:"
        //                + cont);
        //        log.println(" now:" + now);
        //        log.println(" test:" + test);
        //        log.println(" going:" + going);

        return moveAngle;
    }

    private void setAccDir() {
        //        int newAccDir= vels[0] - vels[1];
        //        newAccDir=
        //            (newAccDir < STABLE) : DOWN ? (newAccDir > STABLE) : UP ? STABLE;
        //        switch (accDir) {
        //            case STABLE :
        //                if (newAccDir < STABLE) {}
        //            case UP :
        //            case DOWN :
        //                }
        //        accDir= newAccDir;
    }

    public void setScanned(ScannedRobotEvent e, AdvancedRobot ft) {
        //        log.println("scanned " + e.getName() + "at:" + e.getTime());
        // shifta amostras
        if (!this.isAlive()) {
            return;
        }

        if (e.getEnergy() <= 0.1) {
            this.setDisabled(true);
        } else {
            this.setDisabled(false);
        }

        amostras++;

        timesDelta= e.getTime() - time;
        headsDelta= RoboMath.NormaliseBearing(e.getHeadingRadians() - head);

        velsDelta= (e.getVelocity() - vel);
        lifesDelta= (e.getEnergy() - life);

        life= e.getEnergy();
        head= e.getHeadingRadians();
        time= e.getTime(); //sera'ft.getTime??? pensar.
        vel= e.getVelocity();

        headsSum += head;
        velsSum += Math.abs(vel);
        /////////////

        if ((velsDelta < 0) && (vel == 0)) {
            phasis= time - lastStop;
            lastStop= time;
            this.historyMatch= (int)phasis;
            if (historyMatch > maxHistMatch)
                historyMatch= maxHistMatch;
        }

        //bearing = e.getBearing();

        //the next line gets the absolute bearing to the point where the bot is
        absbearing_rad=
            (ft.getHeadingRadians() + e.getBearingRadians())
                % (2 * RoboMath.PI);

        x= ft.getX() + Math.sin(absbearing_rad) * e.getDistance();
        //works out the x coordinate of where the target is
        y= ft.getY() + Math.cos(absbearing_rad) * e.getDistance();
        //works out the y coordinate of where the target is

        //        log.println(
        //            "***********   scanned "
        //                + e.getName()
        //                + "at:"
        //                + e.getTime()
        //                + "/"
        //                + ft.getTime()
        //                + " "
        //                + x
        //                + ","
        //                + y);

        double tbear=
            RoboMath.normalRelativeAngle(
                RoboMath.normalRelativeAngle(e.getBearing())
                    + RoboMath.normalRelativeAngle(ft.getHeading())
                    - 180);

        attackAngle=
            RoboMath.normalRelativeAngle(
                RoboMath.normalRelativeAngle(e.getHeading()) - tbear);
        //log.println(e.getTime()+"/"+ft.getTime()+"/"+times[0] +" AXETARGET head"+RoboMath.normalRelativeAngle( e.getHeading())+" bear"+RoboMath.normalRelativeAngle( e.getBearing())+ " aa:" +attackAngle+ " "+e.getName()+ " tbear:"+tbear+" Hatamoto head:"+RoboMath.normalRelativeAngle( ft.getHeading()));
        //        AxeVector last;
        //        if (interpolated.size() > 0) {
        //
        //            last= (AxeVector)interpolated.get(interpolated.size() - 1);
        //        } else {
        //            last= new AxeVector(x, y);
        //        }
        //        
        //        double x0= last.getX();
        //        double y0= last.getY();
        //        double Dx= x - x0;
        //        double Dy= y - y0;
        //        double dx= Dx / timesDelta;
        //        double dy= Dy / timesDelta;
        //
        //        double mod= Math.sqrt(dx * dx + dy * dy);
        //        AxeVector interpol= null;
        //
        //        for (int i= 0; i < timesDelta; i++) {
        //            x0 += dx;
        //            y0 += dy;
        //            interpol= new AxeVector(x0, y0); //, tetha, mod);
        //            //            log.println(
        //            //                "interpolated(" + interpolated.size() + ") mod:"+mod+" " + interpol);
        //            interpolated.add(interpol);
        //
        //            deslocationSquaredSum += Math.pow(mod, 2);
        //            deslocationSum += mod;
        //            //x0 = x0 + interpol.getX();	
        //            //y0 = y0 + interpol.getY();
        //
        //        }
        //		log.println("InterpolatedData size:" + InterpolatedData.get().size() );

        //StaticDataCenter.add(x,y,time,timesDelta );
        //VectorPMGun.addSample( StaticDataCenter.get(),AxeBot.getIt().getRoundNum(),(int)time, (int)timesDelta);

        //        log.println(
        //            " DESVIO PADRAO DO INTERPOLATED:" + this.getInterpolatedSD()+" mod:"+mod);
        bearing= e.getBearingRadians();

        distance= e.getDistance();

        botData.add(x, y, time, timesDelta, distance, this.getHeadToMe());

        setBotShape();

		if(this.getLastLifeDiff()!=0){
			System.out .println(this.getName()+" lifeDiff:"+this.getLastLifeDiff());
		}
		double lifeDiff = this.getLastLifeDiff()-this.getExpectedLifeDiff();
		this.setExpectedLifeDiff(0);
        if ((e.getEnergy() > 0.0)&&(lifeDiff >= -3.0)
            && (lifeDiff < 0.0)) {

            //enemy fired bullet!!
            heat= 0.2 * (e.getEnergy() - lifeDiff - 0.1) + 0.92;

            AxeBot me= AxeBot.getIt();
            double bullPow= Math.abs(lifeDiff);
            double bullVel= RoboMath.getBulletVelocity(bullPow);
            double dist=
                RoboMath.getrange(
                    this.getX(),
                    this.getY(),
                    me.getX(),
                    me.getY());
            double timeToHit= me.getTime() + (dist / bullVel);

            this.lastBulletPow= bullPow;

            if ((Double.isNaN(canHitMe)) || (timeToHit < canHitMe)) {
                setCanHitMe(timeToHit);
            }

            stratego.setEnemyFired(me.getMoveStrat());
            if (((Okami)me).getMyPilot() != null) {

                ((Okami)me).getMyPilot().enemyFired();
            }

            new EnemyWave(bullPow, me.getTime(), this);
        } else if (
            (this.getLastLifeDiff() >= -3.0)
                && (this.getLastLifeDiff() < 0.0)) {
            System.out.println("DESPREZANDO, GUN HEAT:" + heat);
        }

        this.doMirror();

    }

    private void doMirror() {
        double val= AntiMirrorPilot.getOpposite(this);
        mirrorList[mirrorQt % MIRROR_LIST_MAX_SIZE]= val;
        mirrorQt++;
    }

    public double getMirrorAvg() {
        return (mirrorQt < MIRROR_LIST_MAX_SIZE)
            ? Double.NaN
            : RoboMath.getSum(mirrorList)
                / ((mirrorQt < MIRROR_LIST_MAX_SIZE)
                    ? mirrorQt
                    : MIRROR_LIST_MAX_SIZE);
        // (mirrorQt<40)?Double.NaN :mirrorAmt/mirrorQt;
    }

    //    private double getInterpolatedSD() {
    //        return RoboMath.getStandDeviation(
    //            this.deslocationSum,
    //            this.deslocationSquaredSum,
    //            interpolated.size() - 1);
    //    }

    //    private Point2D.Double guessPosition(long when, int aimKind, double tvel) {
    //        double diff= when - time;
    //        double newY, newX;
    //        /**if the change in heading is significant, use circular targeting**/
    //
    //        if ((Math.abs(this.headsDelta) > 0.00001)
    //            && ((aimKind == Stratego.AIM_CIRCULAR)
    //                || (aimKind == Stratego.AIM_CIRCULAR_AVG)
    //                || (aimKind == Stratego.AIM_CIRCULAR_ACC))) {
    //            double radius= tvel / this.headsDelta;
    //            double tothead= diff * this.headsDelta;
    //            newY=
    //                y
    //                    + (Math.sin(head + tothead) * radius)
    //                    - (Math.sin(head) * radius);
    //            newX=
    //                x
    //                    + (Math.cos(head) * radius)
    //                    - (Math.cos(head + tothead) * radius);
    //        }
    //        /**If the change in heading is insignificant, use linear**/
    //        else {
    //            newY= y + Math.cos(head) * tvel * diff;
    //            newX= x + Math.sin(head) * tvel * diff;
    //        }
    //        //ft.//out.println("guessPosition x,y:"+newX+","+newY);
    //        return new Point2D.Double(newX, newY);
    //    }
    //
    //    private int findBestMatch(double timeToIt) {
    //        int lastSample= 0;
    //        double ac= 0;
    //        for (int j= clock.size() - 1; j >= 1; j--) {
    //            ac += ((Long)clock.get(j)).doubleValue()
    //                - ((Long)clock.get(j - 1)).doubleValue();
    //            if (ac >= timeToIt) {
    //                lastSample= j - 1;
    //                break;
    //            }
    //        }
    //
    //        if (lastSample == 0)
    //            return 0;
    //
    //        int posQ= pos.size();
    //
    //        if (posQ < 2)
    //            return 0;
    //
    //        AxeVector srch=
    //            ((AxeVector)pos.get(posQ - 1)).minus(
    //                (AxeVector)pos.get((posQ - 2)));
    //        AxeVector test= null;
    //        AxeVector dif= null;
    //        double difMod= Double.NaN;
    //        double difModTst;
    //        int reference= 0;
    //            for (int i= 1; i < lastSample /*(posQ-2)*/; i++) {
    //            test= ((AxeVector)pos.get(i)).minus((AxeVector)pos.get((i - 1)));
    //            dif= srch.minus(test);
    //            difModTst= dif.getModule();
    //            if (Double.isNaN(difMod)) {
    //                reference= i;
    //                difMod= difModTst;
    //            } else if (difModTst < difMod) {
    //                reference= i;
    //                difMod= difModTst;
    //            }
    //
    //        }
    //
    //        //log.println("findBestMatch:"+reference+" posQ:"+posQ+" difMod:"+difMod);
    //        return reference;
    //    }
    //
    //    private Point2D.Double PatternMatch(AdvancedRobot ft, double firePower) {
    //        //int interpols=10;
    //        //Point2D.Double p;
    //        //p = new Point2D.Double(x, y);
    //        double bVel= (20 - (3 * firePower));
    //
    //        double timeToIt= this.getDistance() / bVel;
    //
    //        int match= findBestMatch(timeToIt);
    //
    //        int clockMatch= ((Long)clock.get(match)).intValue();
    //        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
    //        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
    //        int c= match;
    //        double bulDS, targetDS;
    //        double bulToTargetS;
    //
    //        AxeVector nowVec= (AxeVector)pos.get(pos.size() - 1);
    //        AxeVector refVec= (AxeVector)pos.get((match));
    //        AxeVector nextVec= (AxeVector)nowVec; //.clone();
    //        AxeVector tmp;
    //
    //        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());
    //
    //        do {
    //            try {
    //                c++;
    //                tmp= nowVec.plus((AxeVector)pos.get(c)).minus(refVec);
    //                nextVec= tmp;
    //                bulDS= bVel * (((Long)clock.get(c)).intValue() - clockMatch);
    //                targetDS= nextVec.getRelativeModule(ft.getX(), ft.getY());
    //
    //                bulToTargetS= targetDS - bulDS;
    //            } catch (ArrayIndexOutOfBoundsException e) {
    //                break;
    //            }
    //        } while (bulToTargetS > 0);
    //
    //        return new Point2D.Double(nextVec.getX(), nextVec.getY());
    //
    //    }
    //
    //    private Point2D.Double estimateMove(double firePower) {
    //
    //        try {
    //            int measured= interpolated.size();
    //
    //            if (measured < 2) {
    //                return new Point2D.Double(this.getX(), this.getY());
    //            }
    //
    //            double bVel= (20 - (3 * firePower));
    //
    //            double timeToIt= this.getDistance() / bVel;
    //
    //            int samples= 5;
    //            int sampleSize= (int)timeToIt;
    //
    //            if (measured < sampleSize) {
    //                sampleSize= measured;
    //                samples= 1;
    //            } else if (measured < (samples * sampleSize)) {
    //                samples= (int) (measured / sampleSize);
    //            }
    //
    //            int last= measured - 1;
    //            int first= last - sampleSize + 1;
    //
    //            //            AxeBot.getIt().out.println(
    //            //                "measured:"
    //            //                    + measured
    //            //                    + " samples:"
    //            //                    + samples
    //            //                    + " sampleSize:"
    //            //                    + sampleSize);
    //
    //            double sumMoveModule= 0;
    //
    //            for (int i= 0; i < samples; i++) {
    //                //                AxeBot.getIt().out.println("last:" + last + " first:" + first);
    //                AxeVector srch=
    //                    ((AxeVector)interpolated.get(last)).minus(
    //                        (AxeVector)interpolated.get((first)));
    //                sumMoveModule += srch.getRelativeModule();
    //                //                AxeBot.getIt().out.println("sumMoveModule:" + sumMoveModule);
    //                last= first;
    //                first= last - sampleSize + 1;
    //            }
    //
    //            double avgMoveModule= sumMoveModule / samples;
    //
    //            //            AxeBot.getIt().out.println(
    //            //                "avgMoveModule:"
    //            //                    + avgMoveModule
    //            //                    + " samples:"
    //            //                    + samples
    //            //                    + " sampleSize:"
    //            //                    + sampleSize);
    //
    //            AxeVector agora= (AxeVector)interpolated.get(measured - 1);
    //            AxeVector antes= (AxeVector)interpolated.get(measured - 2);
    //            AxeVector diff= agora.minus(antes);
    //
    //            //            AxeBot.getIt().out.println("agora:" + agora);
    //            //            AxeBot.getIt().out.println("antes:" + antes);
    //            //            AxeBot.getIt().out.println("diff:" + diff);
    //
    //            double direction= diff.getRelativeTheta();
    //
    //            AxeVector estimated=
    //                new AxeVector(
    //                    this.getX(),
    //                    this.getY(),
    //                    direction,
    //                    avgMoveModule);
    //            //            AxeBot.getIt().out.println("estimateMove:" + estimated);
    //            return new Point2D.Double(estimated.getX(), estimated.getY());
    //        } catch (Throwable e) {
    //            e.printStackTrace(log);
    //            // nao consegui pegar a excessao de estouro do vetor do first. tapando buraco.
    //            return new Point2D.Double(this.getX(), this.getY());
    //        }
    //
    //    }
    //
    //    //interpolated match
    //    private int findBestInterpolMatch(double timeToIt) {
    //        int posQ= interpolated.size();
    //
    //        if (posQ < timeToIt)
    //            return 0;
    //
    //        int startSample= posQ - (int)timeToIt - 1;
    //
    //        AxeVector srch= ((AxeVector)interpolated.get(interpolated.size() - 1));
    //
    //        AxeVector srch50= null;
    //        if (posQ > 50)
    //            srch50=
    //                ((AxeVector)interpolated.get(posQ - 1)).minus(
    //                    (AxeVector)interpolated.get((posQ - 51)));
    //        ;
    //        AxeVector test= null;
    //        AxeVector test50= null;
    //
    //        AxeVector dif= null;
    //        AxeVector dif50= null;
    //
    //        double difMod= Double.NaN;
    //        double difModTst;
    //
    //        double difMod50= Double.NaN;
    //        double difModTst50;
    //
    //        int reference= posQ - 1;
    //
    //            for (int i= startSample /*(posQ-2)*/; i >= 0; i--) {
    //            test= ((AxeVector)interpolated.get(i));
    //
    //            dif= srch.minus(test);
    //            difModTst= dif.getModule();
    //
    //            try {
    //                test50=
    //                    ((AxeVector)interpolated.get(i)).minus(
    //                        (AxeVector)interpolated.get((i - 50)));
    //                dif50= srch50.minus(test50);
    //                difModTst50= dif50.getModule();
    //            } catch (Throwable e) {
    //                test50= null;
    //                dif50= null;
    //                difModTst50= Double.MAX_VALUE;
    //            }
    //
    //            if (Double.isNaN(difMod)) {
    //                reference= i;
    //                difMod= difModTst;
    //                difMod50= difModTst50;
    //            } else if (difModTst < difMod) {
    //                reference= i;
    //                difMod= difModTst;
    //                difMod50= difModTst50;
    //            } else if (difModTst == difMod) {
    //                if ((srch50 != null) && (dif50 != null)) {
    //                    if (Double.isNaN(difMod50)) {
    //                        reference= i;
    //                        difMod= difModTst;
    //                        difMod50= difModTst50;
    //                    } else if (difModTst50 < difMod50) {
    //                        reference= i;
    //                        difMod= difModTst;
    //                        difMod50= difModTst50;
    //                    }
    //                }
    //
    //            }
    //
    //        }
    //        //log.println("findBestMatch:"+reference+" posQ:"+posQ+" difMod:"+difMod);
    //        return reference;
    //    }
    //
    //    private Point2D.Double interpolatedMatch(
    //        AdvancedRobot ft,
    //        double firePower) {
    //        //int interpols=10;
    //        //Point2D.Double p;
    //        //p = new Point2D.Double(x, y);
    //        double bVel= (20 - (3 * firePower));
    //        double timeToIt= this.getDistance() / bVel;
    //        int match= findBestInterpolMatch(timeToIt);
    //
    //        //int clockMatch = ((Long)clock.elementAt(match)).intValue();
    //        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
    //        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
    //        int c= match;
    //        double bulDS, targetDS;
    //        double bulToTargetS;
    //
    //        AxeVector nowVec= (AxeVector)interpolated.get(interpolated.size() - 1);
    //        AxeVector refVec= (AxeVector)interpolated.get((match));
    //        AxeVector nextVec= (AxeVector)nowVec; //.clone();
    //        AxeVector tmp;
    //
    //        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());
    //
    //        do {
    //            try {
    //                c++;
    //                tmp= nowVec.plus((AxeVector)interpolated.get(c)).minus(refVec);
    //                nextVec= tmp;
    //                bulDS= bVel * (c - match);
    //                ;
    //                targetDS= nextVec.getRelativeModule(ft.getX(), ft.getY());
    //
    //                bulToTargetS= targetDS - bulDS;
    //            } catch (ArrayIndexOutOfBoundsException e) {
    //                break;
    //            }
    //        } while (bulToTargetS > 0);
    //
    //        return new Point2D.Double(nextVec.getX(), nextVec.getY());
    //
    //    }
    //
    //    //absolute interpolated match
    //    private int findBestHistoryInterpolMatch(double timeToIt) {
    //        int posQ= interpolated.size();
    //
    //        //if(posQ < 2) return 0;
    //        if (posQ < timeToIt)
    //            return 0;
    //
    //        int startSample= posQ - (int)timeToIt - 1;
    //
    //        int wide;
    //        if (startSample /*(posQ-1)*/
    //            < this.historyMatch)
    //            wide= startSample
    //            /*(posQ-1)*/;
    //        else
    //            wide= this.historyMatch;
    //
    //        //prepara o vetor com o historico atual
    //        Vector history= new Vector();
    //        for (int i= posQ - 1; i > (posQ - 1 - wide); i--) {
    //            history.addElement(
    //                ((AxeVector)interpolated.get(i)).minus(
    //                    (AxeVector)interpolated.get((i - 1))));
    //        }
    //
    //        ///////////
    //
    //        AxeVector srch=
    //            ((AxeVector)interpolated.get(posQ - 1)).minus(
    //                (AxeVector)interpolated.get((posQ - 2)));
    //        AxeVector test= null;
    //        AxeVector dif= null;
    //        double difMod= Double.NaN;
    //        double difModTst;
    //        Integer reference= null;
    //        //procura o melhor match
    //            for (int i= 1; i < startSample /*(posQ-2)*/; i++) {
    //            test=
    //                ((AxeVector)interpolated.get(i)).minus(
    //                    (AxeVector)interpolated.get((i - 1)));
    //            dif= srch.minus(test);
    //            difModTst= dif.getModule();
    //            if (Double.isNaN(difMod) || (difModTst < difMod)) {
    //                difMod= difModTst;
    //                //reference = new Integer(i);
    //            }
    //        }
    //
    //        if (Double.isNaN(difMod))
    //            return 0;
    //
    //        //log.println("findBestHistoryInterpolMatch:"+reference.intValue()+" posQ:"+posQ+" difMod:"+difMod+" time:"+HataMoto.getIt().getTime());
    //
    //        //if(reference != null)
    //        //return reference.intValue();
    //
    //        Vector iguais= new Vector();
    //        //procura os iguais
    //            for (int i= 1; i < startSample /*(posQ-2)*/; i++) {
    //            test=
    //                ((AxeVector)interpolated.get(i)).minus(
    //                    (AxeVector)interpolated.get((i - 1)));
    //            dif= srch.minus(test);
    //            difModTst= dif.getModule();
    //            if (difModTst <= (difMod + 0.0001)) {
    //                iguais.addElement(new Integer(i));
    //            }
    //        }
    //
    //        //procura entre os iguais o com melhor historico
    //        double hisDifMod= Double.NaN;
    //        double hisDifModTst;
    //        //Integer reference= null;
    //        int ref= 0;
    //        //int wideRef = 0;
    //        for (int j= 0; j < iguais.size(); j++) {
    //            ref= ((Integer)iguais.elementAt(j)).intValue();
    //            hisDifModTst= 0;
    //            if ((ref - 1) < this.historyMatch)
    //                continue;
    //            for (int i= 0; i < wide; i++) {
    //                test=
    //                    ((AxeVector)interpolated.get(ref - i)).minus(
    //                        (AxeVector)interpolated.get((ref - i - 1)));
    //                dif= ((AxeVector)history.elementAt(wide - i - 1)).minus(test);
    //                hisDifModTst += dif.getModule();
    //            }
    //
    //            if (Double.isNaN(hisDifMod) || (hisDifModTst < hisDifMod)) {
    //                reference= new Integer(ref);
    //                hisDifMod= hisDifModTst;
    //            }
    //        }
    //
    //        if (reference == null)
    //            reference= (Integer)iguais.firstElement();
    //        //log.println("findBestHistoryInterpolMatch:"+reference.intValue()+" posQ:"+posQ+" difMod:"+hisDifMod+" iguais.size:"+iguais.size());
    //        return reference.intValue();
    //        ///////////
    //
    //    }
    //
    //    private Point2D.Double historyInterpolatedMatch(
    //        AdvancedRobot ft,
    //        double firePower) {
    //        //int interpols=10;
    //        //Point2D.Double p;
    //        //p = new Point2D.Double(x, y);
    //        double bVel= (20 - (3 * firePower));
    //
    //        double timeToIt= this.getDistance() / bVel;
    //
    //        int match= findBestHistoryInterpolMatch(timeToIt);
    //
    //        //int clockMatch = ((Long)clock.elementAt(match)).intValue();
    //        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
    //        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
    //        int c= match;
    //        double bulDS, targetDS;
    //        double bulToTargetS;
    //
    //        AxeVector nowVec= (AxeVector)interpolated.get(interpolated.size() - 1);
    //        AxeVector refVec= (AxeVector)interpolated.get((match));
    //        AxeVector nextVec= (AxeVector)nowVec; //.clone();
    //        AxeVector tmp;
    //
    //        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());
    //
    //        do {
    //            try {
    //                c++;
    //                tmp= nowVec.plus((AxeVector)interpolated.get(c)).minus(refVec);
    //                nextVec= tmp;
    //                bulDS= bVel * (c - match);
    //                targetDS= nextVec.getRelativeModule(ft.getX(), ft.getY());
    //
    //                bulToTargetS= targetDS - bulDS;
    //            } catch (ArrayIndexOutOfBoundsException e) {
    //                break;
    //            }
    //        } while (bulToTargetS > 0);
    //
    //        return new Point2D.Double(nextVec.getX(), nextVec.getY());
    //
    //    }

    //    public double getFirePwr(AdvancedRobot ft, int inFront) {
    //		
    ////        //        if (aimKind == Stratego.AIM_TOMMYGUN2) {
    ////        //            int qt= ((mgun2lim * 2));
    ////        //            int ref= mgun2pos + mgun2lim;
    ////        //
    ////        //            //if(mgun2step == -1)
    ////        //            //	ref = Math.abs(ref - qt);
    ////        //            if (mgun2dir > 0)
    ////        //                ref= Math.abs(qt - ref);
    ////        //
    ////        //            double pwrstep= (2.9) / (double) (qt);
    ////        //
    ////        //            return (pwrstep * (double)ref) + 0.1;
    ////        //
    ////        //        }
    ////
    ////        //double targetDiam= Math.max(ft.getHeight(), ft.getWidth());
    ////        //double pwr = (800+targetDiam)/getDistance();//calibra a distancia
    ////        double pwr= (Math.pow(300, 1.5) * 3) / Math.pow(getDistance(), 1.5);
    ////        //calibra a distancia
    ////
    ////        //if(HataMoto.getIt().getOthers()>2)
    ////        //	pwr += 1;
    ////
    ////        pwr= pwr * inFront;
    ////
    ////        //og.println(" projetil calibrado a distancia:"+pwr+" getDistance():"+getDistance()); 		
    ////        //pwr = pwr*Math.pow(ft.getEnergy()/100,0.25);//calibra pela vida
    ////        ////out.println(" projetil calibrado a energia:"+pwr+" getEnergy:"+getEnergy()); 		
    ////        //        if (inFront < 2) {
    ////        //            double aat = Math.abs(getAttackAngle());
    ////        //            if (aat > 90)
    ////        //                aat -= 180;
    ////        //
    ////        //            aat = Math.abs(aat);
    ////        //
    ////        //            double modif = 1 / Math.pow((aat / 120) + Math.pow(0.5, 0.5), 2);
    ////        //            //log.println(" projetil calibrado pelo angulo de ataque:"+aat+" antes:"+pwr+" depois:"+(pwr*modif)); 		
    ////        //
    ////        //            pwr *= modif;
    ////        //            //if(aat < 15) 
    ////        //            //	pwr *= 2;
    ////        //            //else
    ////        //            //	if(aat > 75) 
    ////        //            //	pwr /= 2;
    ////        //        }
    ////
    ////        //double lim = 15;
    ////
    ////        //double pwr = 0.1;
    ////        if (ft.getEnergy() > 10) {
    ////            //double desvio = 3*(this.getEnergy()/100);
    ////            //desvio = Math.random()*6 - 3;
    ////            //pwr = pwr + desvio;//(pwr+((desvioVida*Math.random())-(desvioVida/2)));
    ////            ////out.println(" projetil calibrado pelo acaso:"+pwr+" desvio:"+desvio);   
    ////
    ////            //if(this.getEnergy() > 20)
    ////            //calibra pelo angulo de ataque
    ////            /*double aa = Math.abs(aat);
    ////            
    ////            
    ////            if(aa<=lim)
    ////            {
    ////            	pwr = pwr + ((lim - aa)/lim)*3;
    ////            	//out.println(jaera.getName()+" projetil calibrado pelo angulo de ataque:"+aa+" incremento:"+(((lim - aa)/lim)*3));
    ////            }*/
    ////
    ////            double ajuste= 3 * stratego.getAvgDistHit(this);
    ////
    ////            if (!Double.isNaN(ajuste))
    ////                pwr= pwr + ajuste;
    ////
    ////            //log.println(" projetil calibrado pelos acertos:"+pwr);   
    ////
    ////            //pwr = pwr+(acertados);//calibra pelos acertados
    ////        }
    ////
    ////        /*if(HataMoto.getIt().getOthers() == 1){
    ////        			pwr = pwr / 2;
    ////        		}*/
    ////
    ////        if (ft.getEnergy() <= 10) {
    ////
    ////            pwr= stratego.getAvgDistHit(this);
    ////
    ////            //log.println(" projetil calibrado avgHit:" + pwr);
    ////            if (ft.getEnergy() <= 10) {
    ////                pwr *= ft.getEnergy() / 10;
    ////                //log.println(" projetil calibrado energy < 10:" + pwr);
    ////            }
    ////
    ////        }
    ////
    ////        if (Double.isNaN(pwr)) {
    ////            pwr= 0.1;
    ////        }
    ////
    ////        double prizeEdge= 2;
    ////
    ////        pwr += (this.getHitsOnARow() >= prizeEdge)
    ////            ? 1
    ////            : ((this.getHitsOnARow() >= (prizeEdge - 1)) ? 0.5 : 0);
    ////
    ////        ////out.println(" projetil calibrado pelos acertos:"+pwr+" acertados:"+acertados);   
    ////
    ////        //double desvioVida = 3*(this.getEnergy()/100);
    ////        //pwr = (pwr+((desvioVida*Math.random())-(desvioVida/2)));
    ////        ////out.println(" projetil calibrado pelo acaso:"+pwr+" desvioVida:"+desvioVida);   
    ////        double damage= getLastEnergy();
    ////        double max;
    ////
    ////        if (damage <= 4) {
    ////            max= damage / 4;
    ////        } else {
    ////            max= (damage + 2) / 6;
    ////        }
    ////
    ////        if (max > 3) {
    ////            max= 3;
    ////        } else if (max < 0.1) {
    ////            max= 0.1;
    ////        }
    ////
    ////        if (pwr > max) {
    ////            pwr= max;
    ////        } else if (pwr < 0.1) {
    ////            pwr= 0.1;
    ////        }
    ////
    ////        if (ft.getEnergy() - pwr <= 0.1) {
    ////            ////out.println("voltando! getEnergy:"+getEnergy()+" pwr:"+pwr);
    ////            pwr= 0;
    ////
    ////        }
    ////
    ////        //log.println("*** POTENCIA DE TIRO FINAL pwr:" + pwr);
    ////        return pwr;
    //    }
    //
    //    //    public  double getBestAvgHit() {
    //    //        return stratego.getBestAvgHit();
    //    //    }
    //
    //    //    public int getBestMoving() {
    //    //        return stratego.getBestMoving();
    //    //    }
    //
    //    //    public  double getBestAvgDistHit() {
    //    //        return stratego.getBestAvgDistHit(this.getDistance());
    //    //    }

    //    public double getGun(AdvancedRobot ft, double firePower, int aimKind) {
    //        long time= 0;
    //        long nextTime;
    //        int interpols= 10;
    //        Point2D.Double p;
    //        p= new Point2D.Double(x, y);
    //        //ft.//out.println("p: x,y:"+p.x+","+p.y+" vars:"+x+","+y);AIM_INTERPOLATED_MATCH
    //        if (aimKind == Stratego.AIM_STATIC) {
    //            p= new Point2D.Double(x, y);
    //        } else if (aimKind == Stratego.AIM_HISTORY_MATCH) {
    //
    //            p= historyInterpolatedMatch(ft, firePower);
    //
    //        } else if (aimKind == Stratego.AIM_INTERPOLATED_MATCH) {
    //            p= interpolatedMatch(ft, firePower);
    //        } else if (aimKind == Stratego.AIM_PATTERN_MATCH) {
    //            p= PatternMatch(ft, firePower);
    //        } else if (aimKind == Stratego.AIM_MOVEMENT_ESTIMATED) {
    //            p= estimateMove(firePower);
    //        } else {
    //
    //            double v= vel;
    //
    //            if ((aimKind == Stratego.AIM_LINEAR_AVG)
    //                || (aimKind == Stratego.AIM_CIRCULAR_AVG)) {
    //
    //                v= this.velsSum / amostras;
    //            }
    //
    //            //this.velsDelta= v;
    //
    //            int timeToAccZero= 0;
    //
    //            if ((aimKind == Stratego.AIM_CIRCULAR_ACC)
    //                || (aimKind == Stratego.AIM_LINEAR_ACC)) {
    //                acc= this.velsDelta;
    //
    //                if (acc != 0) {
    //                    if (((vel >= 0) && (acc > 0)) || ((vel <= 0) && (acc < 0)))
    //                        timeToAccZero= (int)Math.abs((8 - vel) / acc);
    //                    else
    //                        timeToAccZero= (int)Math.abs((-vel) / acc);
    //
    //                }
    //                double timeToTarget=
    //                    (int)Math.round(
    //                        (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
    //                            / (20 - (3 * firePower))));
    //
    //                for (int i= 0;
    //                    ((i < timeToAccZero) && (i < timeToTarget));
    //                    i++) {
    //                    v += acc;
    //                    time= ft.getTime() + i;
    //                    p= guessPosition(time, aimKind, v);
    //                }
    //            }
    //
    //            for (int i= 0; i < interpols; i++) {
    //                nextTime=
    //                    (int)Math.round(
    //                        (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
    //                            / (20 - (3 * firePower))));
    //                time= ft.getTime() + nextTime;
    //
    //                //if(aimKind != Stratego.AIM_STATIC)
    //                p= guessPosition(time, aimKind, v);
    //            }
    //            //ft.//out.println("getGun time:"+time+" x,y:"+p.x+","+p.y);
    //        }
    //        double targetSlack= Math.max(targetHeight, targetWidth) * (7 / 8);
    //        //estima o centro, melhorar!!
    //        if ((p.x) < targetSlack)
    //            p.x= targetSlack;
    //        if ((p.y) < targetSlack)
    //            p.y= targetSlack;
    //        if ((p.x) > maxX - targetSlack)
    //            p.x= maxX - targetSlack;
    //        if ((p.y) > maxY - targetSlack)
    //            p.y= maxY - targetSlack;
    //
    //        //offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
    //        double gunOffset=
    //            ft.getGunHeadingRadians()
    //                - (Math.PI / 2 - Math.atan2(p.y - ft.getY(), p.x - ft.getX()));
    //
    //        //		setTurnGunLeftRadians(NormaliseBearing(gunOffset));
    //        setTimeToHit(
    //            Math.round(
    //                (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
    //                    / RoboMath.getBulletVelocity(firePower))));
    //        return gunOffset;
    //    }

    //    public Object clone() {
    //        AxeTarget ret= null;
    //        try {
    //            ret= (AxeTarget)super.clone();
    //            for (int i= 0; i < maxAmostras; i++) {
    //                ret.heads[i]= heads[i];
    //                ret.times[i]= times[i];
    //                ret.vels[i]= vels[i];
    //            }
    //
    //        } catch (Throwable e) {
    //            ret= null;
    //            ////out.println("************** nao cloneou!");
    //        }
    //        return ret;
    //    }

    /**
     * @return
     */
    public String getAlvo() {
        return alvo;
    }

    /** Calcula o angulo referente ao heading do alvo em relao ao meu 
     * (0 graus  o vetor ligando o alvo  mim). 
     * @return o angulo (180 - (-180)).
     */
    public double getAngle() {
        AxeBot me= AxeBot.getIt();
        AxeVector av= new AxeVector(this.pos(), me.pos());
        //        return RoboMath.normalRelativeAngle(
        //            av.getRelativeTheta() - this.getHeading());

        double refAng= this.getMoveAngle();
        refAng= (Double.isNaN(refAng)) ? this.getHeading() : refAng;

        double ang=
            RoboMath.normalRelativeAngle(av.getRelativeTheta() - refAng);

        //        log.println("getAngle:" + ang);

        return ang;
    }

    /**
     * @param string
     */
    public void setAlvo(String string) {
        alvo= string;
        //        HataMoto.getIt().out.println(
        //            "@@@@@@@@ " + this.getName() + " ALVO:" + string);
    }

    /**
     * @return
     */
    public double getCanHitMe() {
        return canHitMe;
    }

    /**
     * @param d
     */
    public void setCanHitMe(double d) {
        canHitMe= d;
    }

    //    public boolean goodFire() {
    //        return stratego.goodFire(this.getDistance());
    //    }
    //
    //    public AxeScoreReg getScore() {
    //        return stratego.getScore();
    //    }
    //
    //    public ArrayList getAllScores() {
    //        return stratego.getAllScores();
    //    }
    //
    //    public ArrayList getMovings() {
    //        return stratego.getMovings();
    //    }

    public Stratego getStratego() {
        return stratego;
    }

    /**
     * @return
     */
    public int getHitsOnARow() {
        return hitsOnARow;
    }

    /**
     * @param i
     */
    public void resetHitsOnARow() {
        hitsOnARow= 0;
    }

    public void incHitsOnARow() {
        hitsOnARow++;
    }

    public void decHitsOnARow() {
        hitsOnARow--;
    }

    /**
     * @return
     */
    //    public AxeVector[][] getInterpolated() {
    //
    //        AxeVector o[]= new AxeVector[interpolated.size()];
    //        o= (AxeVector[])interpolated.toArray(o);
    //
    //        //        for(int i=0; i<o.length;i++){
    //        //        	log.println(i+":"+o[i]);
    //        //        }
    //
    //        this.botPosRecorded[this.botPosRecorded.length - 1]= o;
    //        return this.botPosRecorded;
    //    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        // TODO Auto-generated method stub
        return this.getName()
            + " life:"
            + this.getLastEnergy()
            + " at:"
            + this.pos();
    }

    /**
     * @return
     */
    public boolean isDisabled() {
        return disabled;
    }

    /**
     * @param b
     */
    public void setDisabled(boolean b) {
        disabled= b;
    }

    /**
     * @return
     */
    public double getLastBulletPow() {
        return lastBulletPow;
    }

    /**
     * @return
     */
    public BotData getBotData() {
        return botData;
    }

    /**
     * @return
     */
    public double getExpectedLifeDiff() {
        return expectedLifeDiff;
    }

    /**
     * @param i
     */
    public void setExpectedLifeDiff(double i) {
        expectedLifeDiff= i;
    }

}
