package kawigi.spare.util;

/**
 * EnemyStateChange - stores the change in velocity and direction of a robot over one turn
 * 		According to David Mold, author of MogBot, this is all I need for an iterative pattern matcher.
 */
public class EnemyStateChange
{
	private double deltav, deltatheta;
	//creates a new EnemyStateChange from state1 to state2 over time dt
	public EnemyStateChange(EnemyState state1, EnemyState state2, long dt)
	{
		deltav = state2.getVelocity()-state1.getVelocity();
		deltatheta = state2.getHeading()-state2.getHeading();
		deltatheta = ((deltatheta+Math.PI)%(Math.PI*2)-Math.PI*2)%(Math.PI*2)+Math.PI;
		deltav /= dt;
		deltatheta /= dt;
	}
	
	public EnemyStateChange(double dv, double dh)
	{
		deltav = dv;
		deltatheta = dh;
	}
	
	public double getChangeInVelocity()
	{
		return deltav;
	}
	
	public double getChangeInHeading()
	{
		return deltatheta;
	}
	
	public EnemyState getNextState(EnemyState oldstate)
	{
		double x = oldstate.getX();
		double y = oldstate.getY();
		double heading = oldstate.getHeading();
		double v = oldstate.getVelocity();
		heading +=deltatheta;
		v += deltav;
		x += v*Math.sin(heading);
		y += v*Math.cos(heading);
		oldstate.setState(x, y, v, heading, oldstate.getEnergy(), 10000-oldstate.getTimeElapsed(10000));
		return oldstate;
	}
	
	public double difference(EnemyStateChange other)
	{
		return Math.abs(other.deltatheta-deltatheta)+Math.abs(other.deltav-deltav);
	}
}
