package elloco;
import robocode.*;
import java.awt.*;
//import java.awt.Color;

/**
 * Flower - a robot by (your name here)
 */
public class Flower extends AdvancedRobot
{
//##################################################################
//global data
//##################################################################
	//gun data
	static int hit;
	static int shotsFired;
	double gunAim;	
	   
	//scanner init
	double bearing,heading,velocity,distance;
	int scanmode=0;
	double beammode=2.1;
	int idletime=0;
	double oldEnergy=100;
	long lastHit=0;
	long lastHitE=0;
	double gunPowerE=0;
	
	//move init
	int movemode=0;
	double moveDist=80;
	double optDist=40;
	boolean nearwall=false;
	
	/**
	 * run: Neural's default behavior
	 */
	public void run(){
//##################################################################	
	//init
//##################################################################
		//Gun init
		setAdjustGunForRobotTurn(true);
						
		//Scanner init
		setAdjustRadarForGunTurn(true);
		
		//movement init
		
		//BotColors
		setColors(	Color.GREEN,
					Color.RED,
					Color.PINK,
					Color.YELLOW,
					Color.ORANGE);
		
//##################################################################		
		//mainloop		
//##################################################################
		while(true){
//##################################################################
			scanner();
			move();
			execute();									
//##################################################################
		}
	}
//##################################################################
	//events
//##################################################################

	public void onScannedRobot(ScannedRobotEvent e){
    	bearing=e.getBearingRadians();
		heading=e.getHeadingRadians();
		velocity=e.getVelocity();
		distance=e.getDistance();
		
	
		//scanner
		scanmode=1;
		
		//movement
		if(checkEnemyFire(e.getEnergy())) movemode=1;
		
		//gun-------------------------------------------------------
		if(getEnergy()>3){;
			//aim
			gunAim=bearing+getHeadingRadians();
			gunAim+=Math.asin(Math.sin(Math.PI+gunAim-heading)*velocity/11)-getGunHeadingRadians();
			
			setTurnGunRightRadians(Math.sin(gunAim));
			
			//fire
			if(getGunHeat()==0){
				setFire(3);
			}
		}
		//----------------------------------------------------------
	}

	public void onBulletHit(BulletHitEvent e){
		lastHit=getTime();
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
    	lastHitE=getTime();
		gunPowerE=e.getPower();
	}
 

	
//##################################################################
	//scanner #works in1on1
//##################################################################
	public void scanner(){
		double scannerBearing=9; //0==>sweep
		switch(scanmode){
			case 1: //lock
					scannerBearing=Math.sin(bearing+getHeadingRadians()-getRadarHeadingRadians())*beammode;
					idletime=0;
					scanmode=2;
					break;
			case 2: //idle
					if(idletime>4) scanmode=0;
					idletime++;
					break;
			
		}
		setTurnRadarRightRadians(scannerBearing);
	}

	
	public boolean checkEnemyFire(double energy){
		double delta=oldEnergy-energy+
										((lastHitE==getTime())?(3.0*gunPowerE):0)-
										((lastHit==getTime())?16:0);
		oldEnergy=energy;
		if(delta>0){
			out.println("enemy fired! @power="+delta);
			return true;
		}
			
		return false;
	}
//##################################################################
	//movement system
//##################################################################
	
	
	public void move(){
		
		switch(movemode){
			case 0:	if (getX()<50 || getY()<50 || getX()>getBattleFieldWidth()-50 || getY()>getBattleFieldHeight()-50){
						if(!nearwall) movemode=2;
					}else nearwall=false;
					break;
			case 1:	moveDist*=2*Math.round(Math.random())-1;
					movemode=0;
					break;
			case 2: moveDist*=-1;
					nearwall=true;
					movemode=0;
					break;
		}
		
		
		setTurnRightRadians(Math.sin(bearing-Math.PI/2+Math.signum(moveDist)*(distance-optDist)*0.005));
		setAhead(moveDist);
	}
}		