package cx.util.iiley;

import robocode.*;
import java.awt.geom.Point2D;
import java.util.*;
import java.io.*;
import java.util.zip.*;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Class Statist
 * This class can stat your enemy's hit anlge probability in different distance
 * if you use your properties instead of enemy's,this also can stat your angle probability.
 */

public class Statist
{
	public double MaxHitDiffAngleDegree=50;
	public double MaxHitDiffAngle=Math.toRadians(50);
	private double         targetDirection;	
	private float[][][]    probability; 
	private int            angleDivisionNum;
	private int            distanceDivisionNum;
	private final int      laevDivisionNum=9;
	private long           firedBulletsNum;
	private double         power;
	private ArrayList         waves;
    
	public Statist(){
        //divide shoot angle to 51 pieces
		//divide shoot distance to 6 pieces
		this(7,41,3d);
	}
	public Statist(double maxdeg,int dn,int an,double p){
        this(dn,an,p);
		setMaxHitDiffAngleDegree(maxdeg);
	}
	public Statist(double maxdeg){
        this();
		setMaxHitDiffAngleDegree(maxdeg);
	}
	public Statist(int dn,int an,double p){
		angleDivisionNum=an;                  //divide shoot angle to an pieces
		distanceDivisionNum=dn;                //divide shoot distance to dn pieces
		probability=new float[laevDivisionNum][distanceDivisionNum][angleDivisionNum];
		power=p;
		waves=new ArrayList();
	}
//++++++++++++++++++++++++++++++++PUBLIC METHODS++++++++++++++++++++++++++++++++++
    public void clear(){
		waves.clear();
	}
    public double getPower(){
		return power;
    }
    public void setMaxHitDiffAngleDegree(double deg){
        MaxHitDiffAngleDegree=deg;
        MaxHitDiffAngle=Math.toRadians(deg);
	}
    public double getMostProbabilityHitAngle(double targetDir,double distance,double moveTime){
		int dIndex=getDistanceIndex(distance);
		int mtIndex=getMTIndex(moveTime);
		int mphaIndex=0;
		for(int i=0;i<angleDivisionNum;i++){
			if(probability[mtIndex][dIndex][i]>probability[mtIndex][dIndex][mphaIndex]){
				mphaIndex=i;
			}
		}
		return getAngle(targetDir,mphaIndex);
	}
	public float[] getProbability(double targetDir,double distance,double moveTime){
		int dIndex=getDistanceIndex(distance);
		int mtIndex=getMTIndex(moveTime);
		return probability[mtIndex][dIndex];
	}
	public double getAngleOfIndex(double targetDir,int ind){
		return getAngle(targetDir,ind);
	}
    /**
	 * your must call this method every turn so that the result will be exact
	 */
	public void test(double enemyX,double enemyY,long time){
		for(Iterator tw = waves.iterator(); tw.hasNext(); ){
			
			StatistWave wave = (StatistWave) tw.next();
			
			wave.test(enemyX,enemyY,time);
			if(wave.willHitDiffAngle<10d){
				int dIndex=getDistanceIndex(wave.distance);
				int aIndex=getAngleIndex(wave.willHitDiffAngle,wave.targetDirection);//wave.linePreDiffAngle is targetDirection
				int mtIndex=getMTIndex(wave.moveTime);
                probabilityRoll(mtIndex,dIndex,aIndex);
				tw.remove();

			}else if(wave.willHitDiffAngle==20d){
				tw.remove();
			}
		}
	}
	/**
	 * your must call this method when you fire a bullet
	 * (x,y) is your position when fire
	 * bearing the enemy's bearing to you when fire
	 * distance is the enmey's distance to you when fire
	 * targetDirection:direction target is moving (or if stationary, was moving),1.0 clockwise, -1.0 AntiClockwise
	 * time is the time when fire
	 */
    public void onFire(double x,double y,long time,double absBearing,double targetDirection,
		double distance,double moveTime){
        waves.add(
			new StatistWave(x,y,power,time,absBearing,targetDirection,distance,0d,moveTime)
		);
	}

	public double getAngle(double targetDir,int Index){
		return (2d*MaxHitDiffAngle*Index/(angleDivisionNum-1)-MaxHitDiffAngle)/targetDir;
	}
	public float[][][] getProbability(){
		return probability;
	}
	public void setProbability(float[][][] probability,double power){
		this.probability=probability;
		this.power=power;
	    angleDivisionNum=probability[0][0].length;
	    distanceDivisionNum=probability[0].length;
	    //laevDivisionNum=probability.length;
	}
	public long[][][] getCompressedProbability(){
		int longNum=angleDivisionNum/18;
		if(angleDivisionNum%18>0) longNum++;
		long[][][] cp=new long[laevDivisionNum][distanceDivisionNum][longNum];
		for(int mti=0;mti<laevDivisionNum;mti++){
			for(int di=0;di<distanceDivisionNum;di++){
				float maxp=0.09f;
	        	for(int i=0;i<angleDivisionNum;i++){
		        	if(probability[mti][di][i]>maxp){
		     	    	maxp=probability[mti][di][i];
	        		}
	         	}
				double div=9.001d/maxp;
        		for(int i=0;i<longNum;i++){
					StringBuffer numString=new StringBuffer(30);
		        	for(int j=18*i;j<18*(i+1) && j<angleDivisionNum;j++){
        				long number=(long)Math.round(Math.min(9d,probability[mti][di][j]*div));
						numString.append(number);
        			}
					if(i==0){
    					cp[mti][di][i]=Long.parseLong(numString.toString());
					}else{
						cp[mti][di][i]=Long.parseLong(numString.reverse().toString());
					}
         		}
                
			}
		}
		return cp;
	}
	public void setCompressedProbability(long[][][] cp,double power,AdvancedRobot robot,boolean isprint)
		throws Exception{
		this.power=power;
        int longNum=cp[0][0].length;
	    distanceDivisionNum=cp[0].length;
		angleDivisionNum=36;
		long lastLongValue=cp[0][0][longNum-1];
		//robot.out.println("lastLongValue="+Long.toString(lastLongValue));
        probability=new float[laevDivisionNum][distanceDivisionNum][angleDivisionNum];
        if(longNum!=2){
			throw new Exception("angleDivisionNum="+angleDivisionNum);
		}
		for(int mti=0;mti<laevDivisionNum;mti++){
			for(int di=0;di<distanceDivisionNum;di++){

        		for(int i=0;i<longNum;i++){
        			long compressValue=cp[mti][di][i];
					String numbers=Long.toString(compressValue);
					StringBuffer numbers18=new StringBuffer("000000000000000000");
					numbers18.replace(18-numbers.length(),18,numbers);

					if(i==1){
						numbers18=numbers18.reverse();
					}else if(i==0){

					}else {		
						throw new Exception("longNum="+longNum);
					}
					if(di==2 && isprint){
						robot.out.println(mti+".3."+i+"="+numbers18.toString());
					}
		        	for(int j=18*i;j<18*(i+1) && j<angleDivisionNum;j++){
                        probability[mti][di][j]=getProbabilityFromChar(numbers18.charAt(j%18));
        			}
         		}

			}
		}
	}
	private float getProbabilityFromChar(char c){
		return ((int)c - 48)/(100f);
	}
    /**
	 * save this instance to a file
	 */
	public void save( String name , AdvancedRobot robot){
		try
		{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getFile(name,robot))));
			out.writeObject(probability);
			out.close();
		}
		catch (IOException ex)
		{
			robot.out.println("error when save file : "+ex.getMessage());
		}
	}
	public boolean load( String name , AdvancedRobot robot){
			try
			{
				ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getFile(name,robot))));
				probability = (float[][][])in.readObject();
	            angleDivisionNum=probability[0][0].length;
	            distanceDivisionNum=probability[0].length;
	            //laevDivisionNum=probability.length;
				in.close();
			}
			catch (Exception ex)
			{
				robot.out.println("error when load file : "+ex.getMessage());
				return false;
			}
			return true;
	}
	private File getFile(String name , AdvancedRobot robot){
        File    directory       = robot.getDataDirectory();
        File[]  robotFiles      = directory.listFiles();
        String  fileName=getNameWithoutVersion(name);
        File    file            = robot.getDataFile(fileName);
        long totalBytes=0;
		for(int i=0;robotFiles!=null && i<robotFiles.length;i++){
			totalBytes+=robotFiles[i].length();
		}
		robot.out.println("total bytes="+totalBytes);
		if(totalBytes>190000){
	    	File oldestFile=robotFiles[0];
	    	for(int i=0;i<robotFiles.length;i++){
				if(robotFiles[i].lastModified()<oldestFile.lastModified()){
					oldestFile=robotFiles[i];
				}
	    	}
            try {
				 robot.out.println("There is too much files,i have to delete the old files: "+oldestFile.getName());
                 RobocodeFileOutputStream out = new RobocodeFileOutputStream(oldestFile);
                 out.close();
                 oldestFile.delete();
            } catch (IOException e) {
				robot.out.println("error when delect file : "+e.getMessage());
			}			
		}
		return file;
	}
	private String getNameWithoutVersion(String name){
		return name.substring(0,name.indexOf(" "));
	}

	private void probabilityRoll(int mtIndex,int dIndex,int aIndex){
		for(int i=0;i<probability[mtIndex][dIndex].length;i++){
			probability[mtIndex][dIndex][i]*=0.99d;
		}
		probability[mtIndex][dIndex][aIndex]+=0.01d;
	}
	private int getMTIndex(double moveTime){
		int index=(int)Math.floor(moveTime); 
		if(index>laevDivisionNum-1){
			index=laevDivisionNum-1;
		}else if(index < 0){
			index = 0;
		}
		return index;
	}
	public int getDistanceDivisionNum(){
		return distanceDivisionNum;
	}
	public int getDistanceIndex(double distance){
		int distanceIndex=0;
		if(distanceDivisionNum==5){
    		/**this usage copied from davidalves.net.DuelistMicro.java,thanx davidalves
	    	 * This sets the distance indices as follows:
	    	 * 0:   0 -  90 (Essentially point blank range)
	    	 * 1:  91 - 250
	    	 * 2: 251 - 490
	    	 * 3: 491 - 810
	    	 * 4: 811+
	    	 */
		
    		distanceIndex = (int)Math.round((Math.sqrt(distance / 40.0)))-1;
			if(distanceIndex<0){
				distanceIndex=0;
			}else if(distanceIndex>4){
     			distanceIndex=4;
    		}
		}else{
			double divisionLength=700/distanceDivisionNum;
			if(distance<200d) return 0;
			distanceIndex = (int)Math.ceil((distance-200)/divisionLength);  
			if(distanceIndex>distanceDivisionNum-1){
				distanceIndex=distanceDivisionNum-1;
			}
		}
    	return distanceIndex;
	}
	private int getAngleIndex(double angle,double targetDirection){
		double divisionLength=(MaxHitDiffAngle*2d)/(angleDivisionNum-1);
		int index=(int)Math.round((angle*targetDirection+MaxHitDiffAngle)/divisionLength);
		if(index<0){
			return 0;
		}else if(index>angleDivisionNum-1){
			return angleDivisionNum-1;
		}
		return index;
	}

};
