/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;

/*
 * HalfLinear - A gun class that fires half linearly predicted bullets.
 */
public class HalfLinear extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Last my details
	private Details me = null;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			firePower = initialFirePower;
			fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(), enemy.getVelocity() / 2, 0, firePower);
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		enemy = enemyDetails;
		me = myDetails;
	}
}