/*
 * Created on Aug 4, 2003
 *
 */
package jekl.movement;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.text.*;
import java.util.*;
import jekl.*;
import jekl.utils.*;

/**
 * @author jbishop
 *
 */

public class SurfMove implements Constants, Move {
	public static int		ACCEL_INDICIES	= 3;
	public static int		CLOSING_INDICIES	= 3;
	public static int		LATV_INDICIES	= 5;
	public static int		DIST_INDICIES	= 5;
	public static double 	WIDTH;
	public static double 	HEIGHT;
    public static Rectangle2D.Double field;
    private Point2D.Double middle;
	private Point2D.Double myLocation;
	private Point2D.Double myLastLocation;
	public Enemy target;
    private static float [][][][][] hits;
    private static float [][][] fastHitsBuf;
    private int 	 	 [] hitCounter;
    private int myCircleDir, myLastCircleDir, direction = 1;
    private double myLatVel, myVelocity, myHeading, myLastVelocity, myLastHeading, myLastLatVel;
    private int lastLatVelIndex, enemyWaveCount, lastDecelTime = 0;
    private Wave lastImpactWave;
    public  static int numHits = 0;
	private DarkHallow ar;
	private static boolean gamesAFoot = false;
	public double dangerForward, dangerReverse, dangerStop;
	private ArrayList waves;
	private static NumberFormat nf = NumberFormat.getInstance();

	public SurfMove(DarkHallow _ar) {
		this.ar = _ar;
		field = new Rectangle2D.Double(EDGE, EDGE, (WIDTH = ar.getBattleFieldWidth()) - 2 * EDGE, (HEIGHT = ar.getBattleFieldHeight()) - 2 * EDGE);
		myLocation = new Point2D.Double();
		myLastLocation = new Point2D.Double();
		middle = new Point2D.Double(ar.getBattleFieldWidth() / 2, ar.getBattleFieldHeight() / 2);
		waves = new ArrayList();
		if (hits == null) {
			hits = new float[ACCEL_INDICIES][CLOSING_INDICIES][LATV_INDICIES][DIST_INDICIES][(int) GUESS_FACTORS];
		}

		if (fastHitsBuf == null) {
			fastHitsBuf = new float[CLOSING_INDICIES][DIST_INDICIES][(int) GUESS_FACTORS];
		}
		if (hitCounter == null) {
			hitCounter = new int[DIST_INDICIES];
		}
	}

    public void onScannedRobot(ScannedRobotEvent e) {
		target = ar.getTarget();
		//accellIndex is determined by my velocity last tick and two ticks ago
		int accelIndex = (int)(Math.round(Math.abs(myVelocity)) - Math.round(Math.abs(myLastVelocity)));
		if (accelIndex != 0) {
			accelIndex = accelIndex > 0 ? 2 : 1;
		}
		
        myCircleDir = (myVelocity * Math.sin(myHeading - Utils.normalRelativeAngle(Math.PI + target.getLastAbsBearing())) > 0) ? -1 : 1;
        if ((target.getEnergyDrop() > 0) && (target.getEnergyDrop() <= 3)) {
            target.setLastShot(target.getEnergyDrop());
			int distIndex = (int)Math.min(4, (target.getLastLocation().distance(myLastLocation) / 180));
			int outIndex = JeklUtils.getOutIndex(myLocation, myHeading, (int)JeklUtils.sign(myLastVelocity)) / 2;
			int closingIndex = (target.getLastClosingVelocity() == 0 ? 0 : target.getClosingVelocity() > 0 ? RETREATING : ADVANCING);
			
			Wave w = new Wave(ar);
			w.initializeWave(target.getLastShot(),
				//out index uses values at shot time one tick ago
				hits[accelIndex][closingIndex][(int)Math.round(myLatVel)/2][distIndex], 
				fastHitsBuf[closingIndex][distIndex],
				target.getLastLocation(), 	//targets location updated by original scan, need to use last location to get location at shot time
				myLocation,					//location last tick
				2, 							//advance the bullet 2 ticks to account for RC "magic"
				myLastCircleDir,  
				distIndex
			);
			waves.add(w);
			enemyWaveCount++;
			ar.setHisShots();
		}
		doStats();

		ar.setMaxVelocity(8);
		if (enemyWaveCount == 0 && JeklUtils.getDistanceIndex(target) <= 1 && gamesAFoot) {
			if(target.getLocation().distance(getDestination(myLocation, -direction, WALL_CURVE_DISTANCE)) > 
					target.getLocation().distance(getDestination(myLocation, direction, WALL_CURVE_DISTANCE)) * 1.1)
			{
				direction = -direction;
			}
    	} else if (target.getDistance() <= 150 && JeklUtils.out(myLocation, ar.getHeadingRadians(), WALL_CURVE_DISTANCE, direction)) {
			if (dangerForward >= dangerReverse * .95) {
				direction = -direction;
			}
    	} else {
            if (dangerStop < Math.min(dangerForward, dangerReverse) && (dangerForward > 0 || dangerReverse >  0)) {
    			ar.setMaxVelocity(0);
    		}
    		if (dangerForward > dangerReverse) {
    			direction = -direction;
    		}
    	}
    	
		goTo(getDestination(myLocation, direction, WALL_CURVE_DISTANCE));
		
		//Set variables for the next tick
		dangerForward = 0;								//re-set for next tick
        dangerReverse = 0;
        dangerStop = 0;
		myLastLatVel = myLatVel;						//two ticks ago
		myLatVel = getMyLatVel();						//last tick
		myLastVelocity = myVelocity; 					//two ticks ago
        myVelocity = ar.getVelocity(); 					//last tick
        myLastHeading = myHeading;						//two ticks ago
        myHeading = ar.getHeadingRadians(); 			//last tick
        myLastLocation.setLocation(myLocation);			//two ticks ago
        myLocation.setLocation(ar.getX(), ar.getY()); 	//last tick
        myLastCircleDir = myCircleDir;					//two ticks ago
    }

    public void onHitByBullet(HitByBulletEvent e) {
    	gamesAFoot = true;
		if (lastImpactWave != null && Math.round(lastImpactWave.shotPower) == Math.round(e.getPower())) {
    		hitCounter[lastImpactWave.distIndex]++;
			lastImpactWave.incrementHits();
	        lastImpactWave = null;
    	}
    }
        
    //	------------------------------ MOVEMENT CODE -----------------------------
    //This moves me about the field
    public void goTo(Point2D.Double destination) {

        double angle = Utils.normalRelativeAngle(JeklUtils.getAbsBearing(myLocation, destination) - ar.getHeadingRadians());
		ar.setTurnRightRadians(JeklUtils.backAsFrontHeading(angle));
		ar.setAhead(destination.distance(myLocation) * JeklUtils.backAsFrontDirection(angle) * Math.cos(JeklUtils.backAsFrontHeading(angle)));
    }

    //Gets the point we are going to aim for in the next tick
    public Point2D.Double getDestination(Point2D.Double startFrom, int direct, double distance) {
        double fudge = 0;
        Point2D.Double dest = new Point2D.Double();
        //Orbit closest wave origin if there is one, otherwise orbit the target
        Point2D.Double orbitPoint = (getClosetWave() == null ? target.getLocation() : getClosetWave().shotOrigin);
        double absBearingObritPoint = JeklUtils.getAbsBearing(myLocation,orbitPoint);
        double offSet = orbitPoint.distance(myLocation);
        double evasionAngle = target.getDistance() > 150 ? .2618 : .5236;
		double dir = absBearingObritPoint + (Math.PI / 2) + (evasionAngle * direct * ((offSet > MAX_STAND_OFF_DISTANCE) ? CLOSE_IN : ((offSet < MIN_STAND_OFF_DISTANCE) ? BACK_OFF : 0)));
        int counter = 0;
        do {
            dest.setLocation(startFrom.x + (Math.sin(dir + (fudge * direct)) * distance * direct), startFrom.y + (Math.cos(dir + (fudge * direct)) * (distance * direct)));
            fudge -= .0085; //.5 degrees radians
        } while (!field.contains(dest) && (++counter < 720));
        return dest;
    }
    
    private void doStats() {
		Iterator it = waves.iterator();	
		Wave w;
		int forward = 0;
		int reverse = 0;
		int stop = 0;
		
		while(it.hasNext()) {
			w = (Wave)it.next();
			if ((w.dist += w.bulletVel) >= w.shotOrigin.distance(w.targetLoc) - 18) {
				lastImpactWave = w;
				enemyWaveCount--;
				it.remove();
			}
			dangerForward += w.predictDanger(w.predictImpactLocation(direction, getCDir(),MAX_VELOCITY), getDestination(myLocation, direction, WALL_CURVE_DISTANCE));
			dangerReverse += w.predictDanger(w.predictImpactLocation(-direction, getCDir(),MAX_VELOCITY), getDestination(myLocation, -direction, WALL_CURVE_DISTANCE));
			dangerStop += w.predictDanger(w.predictImpactLocation(direction, getCDir(),0D), getDestination(myLocation, direction, 0));
		}
    }
    
	public double getMyLatVel() {
		return Math.abs(myVelocity * Math.sin(myHeading - Utils.normalRelativeAngle(Math.PI + target.getLastAbsBearing())));
	}

	public double getGuessAngle(int guessIndex, double firePower, int eDirection) {
		return (guessIndex - ((double) (DarkHallow.GUESS_FACTORS - 1) / 2)) / ((DarkHallow.GUESS_FACTORS - 1) / 2) * Math.asin(8.0 / JeklUtils.bulletV(firePower)) * eDirection;
	}
		
	public int getCDir() {
		return (ar.getVelocity() * Math.sin(ar.getHeadingRadians() - Utils.normalRelativeAngle(Math.PI + target.getAbsBearing())) > 0) ? -1 : 1;
	}
	
	public void printHits() {
		int total = 0;
		for (int i = 0; i < DIST_INDICIES; i++) {
			total += hitCounter[i];
			System.out.println("Range Index " + i + ": [" + hitCounter[i] + "] ");
		}
		System.out.println("----------------------- \nTOTAL: " + total);
	}
	
	private Wave getClosetWave() {
		double nearestDist = 10000;
		Wave retVal = null;
		Iterator it = waves.iterator();
		while (it.hasNext()) {
			Wave w = (Wave)it.next();
			if (w.shotOrigin.distance(w.targetLoc) - w.dist < nearestDist) {
				nearestDist = w.shotOrigin.distance(w.targetLoc) - w.dist;
				retVal = w;
			}
		}
		return retVal;
	}
}