/*
 * Locke.java
 *
 * Created on 14 maart 2004, 17:32
 */
/**
 *
 * @author  Vic Stewart
 */
package vic;
import robocode.*;
import robocode.util.Utils;
/** this Robot is gonna be cool! */
public class LockeStationary extends AdvancedRobot
{
    static Enemy enemy = new Enemy();
    boolean scanned;
    double meX, meY, meHeading, meVelocity;
    double lastAim;
    double lastScanTime;
    
    void runGL()
    {
    }
    void initGL()
    {
    }
    
    double getPower()
    {
        double result;
        double distance = enemy.getDistance(meX, meY);
        double close = 140;
        result = 2.0;
        if(distance < close) result = 3;
        result = Math.min(getEnergy()/4, Math.min(enemy.getEnergy()/4, result));
        if (!(getEnergy() > 1 || distance < close)) result=0;
        return result;
    }
    
    void tick()
    {
        enemy.update();
        
        if(getOthers()>0 && scanned)
        {
            double power = getPower();
            double aim, aim_remaining;
 
            enemy.fireWave(power, meX, meY);    //first fire a wave every Tick
            if(getGunHeat()==0 && getEnergy()>0)
            {
                aim = gunDeltaHeading(getGunHeadingRadians(), enemy.aim(power, meX, meY));
                aim_remaining = Math.abs(aim);
                setTurnGunRight(aim);
                if(power >= 0.1)
                {
                    enemy.fired(power, meX, meY);
                    setFire(power);
                }
            }
            else if(getGunHeat()<(getGunCoolingRate()*4) | getTime() < 30)
            {
                    aim = gunDeltaHeading(getGunHeadingRadians(), enemy.aim(power, meX, meY));
                    setTurnGunRight(aim);
            }
        }
        runGL();
    }
    
    void init()
    {
        System.out.println("log size:"+enemy.log.getSize());
        enemy.clear();
        initGL();
        lastScanTime = -1;
        scanned=false;
        setAdjustRadarForGunTurn(true);
    }
    
    public void run()
    {   
        init();
        do
        {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public double gunDeltaHeading(double gunHeading, double targetHeading)
    {
        lastAim=targetHeading;
        double result = Math.toDegrees(targetHeading - gunHeading);
        if(result> 180)result-=360;
        if(result<-180)result+=360;
        return result;
    }
    
    public void onScannedRobot(ScannedRobotEvent e)
    {
        meX=getX();
        meY=getY();
        meHeading=getHeadingRadians();
        meVelocity=getVelocity();
        scan(e);
	tick();
	setTurnRadarRightRadians(Utils.normalRelativeAngle((getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()) * 2);
    }
    
    void scan(ScannedRobotEvent e)
    {
        scanned=true;
        enemy.scanned(e.getTime(), e.getVelocity(), e.getHeadingRadians(), e.getBearingRadians(), e.getDistance(), meX, meY, meHeading, e.getEnergy());
    }
    
    public void onWin(WinEvent e)
    {
        if(getRoundNum() < 7) enemy.postRound();
    }
    
    public void onDeath(DeathEvent e)
    {
        if(getRoundNum() < 7) enemy.postRound();
    }
}
