package djc.movement;

import djc.*;
import djc.util.*;

import java.util.*;
import java.awt.geom.*;

import robocode.*;
import robocode.util.*;

/**
 * My modifications to CoriantumrMovement
 */
public class EvolutionMovement extends CoriantumrMovement
{
	public EvolutionMovement(AbstractDynaBot themyrobot) {
		super(themyrobot);
				
		name = "EVOLUTION";
		movementID = DynaBotConstants.EVOLUTION;
	}
	
	/**
	 * Override the findRisk method.  The idea is to find the point with the
	 * least risk.
	 */
	protected double findRisk(Point2D.Double point)
	{
		double risk = 0;
		Collection enemySet;
		Iterator it = (enemySet = myrobot.theEnemyManager.enemyList.values()).iterator();
		do {
			Enemy e = (Enemy)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = (e.energy+50)/point.distanceSq(e.location);
			
			// DJC - Added this to keep further from enemies hitting me and closer to enemies I'm hitting
			double [][]damageToMe   = (double[][])myrobot.theEnemyManager.enemyDamageToMe.get(e.name);
			double [][]damageFromMe = (double[][])myrobot.theEnemyManager.enemyDamageTo.get(e.name);
			double damageDiff = damageToMe[DynaBotConstants.GAMESTAGE_ALLSTAGES][DynaBotConstants.DIST_SEG_ALL]
								- damageFromMe[DynaBotConstants.GAMESTAGE_ALLSTAGES][DynaBotConstants.DIST_SEG_ALL];
			// Factor down damageDiff to a per-round basis
			damageDiff /= (myrobot.getRoundNum() + 1);
			thisrisk += damageDiff / point.distanceSq(e.location);
			
			//woah, nested iterations!  Here, I'm counting the enemies that are closer to e than the proposed point is.
			//The more, the better, since this robot would be less likely to target me.
			int closer = 0;
			Iterator it2 = enemySet.iterator();
			do {
				Enemy e2 = (Enemy)it2.next();
				if (e.location.distance(e2.location)*.9 > e.location.distance(point))
					closer++;
			} while (it2.hasNext());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			if (closer <= 1 || e.lastHitMe > myrobot.getTime()-200 || e == myrobot.theEnemyManager.currentEnemy)
			{
				//I had to think about this one, but I think DuelistMicroMelee helped me make sure that it was correct.  I can't remember anymore.
				thisrisk *= 2+2*Math.abs(Math.cos(angle(myrobot.location, point) - angle(e.location, myrobot.location)));
			}
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			//if (new Line2D.Double(myLocation, point).intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
			//	thisrisk *= 4;
			risk += thisrisk;
		} while (it.hasNext());
		//add a small antigravity value to the point I was at before now, just to kind of push me in straight
		//lines (this made me too hitable in one-on-one, though):
		if (myrobot.getOthers() > 1) {
			risk += Math.random()/last.distanceSq(point);
			// DJC - Added some repulsion from the center for melees
			risk += myrobot.getOthers() * Math.random() / myrobot.theBattleManager.arenaCenter.distanceSq(point);
		}
		//and repel my current location, to make it more likely that I change my mind before I get to my assigned
		//point (and less likely to change my mind right away maybe):
		risk += Math.random()/5/myrobot.location.distanceSq(point);
		return risk;
	}
	
}
