package djc.util;

import djc.*;
import java.awt.geom.*;     // for Point2D's
import java.util.*; 	    // for collection of waves
import robocode.*;
import robocode.util.*;

/**
 * Enemy class for storing data about the enemy
 */
public class Enemy
{
	/********************************************************************************
	 *                        Member Variables                                      *
	 *******************************************************************************/
    public Point2D.Double location;
    public Point2D.Double lastLocation;
	public static AbstractDynaBot myrobot = null;
	public ArrayList enemyWaves;     // For WaveSurfing
	public String name;
	public double energy;
	public double lastTimePosition;	
	public double lastTimeEnergy;	
	public double lastDistance;	
	public double heading;
	public double absBearing;	
	public double deltaBearing;
	public double angVelocity;
	public double linVelocity;
	public double prevAngVelocity;
	public double prevLinVelocity;
	public double avgAngVelocity;
	public double avgLinVelocity;
	public boolean isAlive;
	public double lastHitMe = 0;
	
	public Enemy(AbstractDynaBot theMyRobot, String myName) {
		myrobot = theMyRobot;
		name = myName;
		isAlive = true;
		enemyWaves = new ArrayList();
	}

	public void reset() {
		energy = 100.0;
		lastTimePosition = 0;
		lastTimeEnergy = 0;
		heading = 0;
		lastDistance = 0;		
		angVelocity = 0;
		linVelocity = 0;
		prevAngVelocity = 0;
		prevLinVelocity = 0;
		avgAngVelocity = 0;
		avgLinVelocity = 0;
		isAlive = true;
		location = new Point2D.Double(-1000,-1000);
		lastLocation = new Point2D.Double(-1000,-1000);
		enemyWaves = new ArrayList();		
	}

	public void updateFromScannedRobotEvent(ScannedRobotEvent event) {
		double newEnergy  = event.getEnergy();  // Attempt to detect enemy firing
		double newLinVel  = event.getVelocity();
		double newHeading = event.getHeadingRadians();
		double currentTime = myrobot.getTime();
		double dT = currentTime - lastTimePosition;
		double dHeading = heading - newHeading;
		double tmpPrevAngVel = angVelocity;
		double newAbsBearing = event.getBearingRadians() + myrobot.getHeadingRadians();
		//double newAbsBearing = event.getBearingRadians();
		
		avgLinVelocity = (linVelocity + newLinVel) / 2.0;
		prevLinVelocity = linVelocity;
		linVelocity = newLinVel;
		heading = newHeading;
		prevAngVelocity = angVelocity;
		angVelocity = dHeading / dT;
		avgAngVelocity = (tmpPrevAngVel + angVelocity) / 2.0;
		lastTimePosition = currentTime;
		lastTimeEnergy = currentTime;
		
		// Check if enemy fired -- TODO - check for false positives by checking velocity decreases of more than 2
		double bulletPower = energy - newEnergy;
		if(bulletPower < 3.01 && bulletPower > .09) {
			enemyFired(bulletPower, name, location);
		}

		absBearing = newAbsBearing;

		// Update location after checking for enemy fire		
		lastDistance = event.getDistance();
		if(location != null) {
			lastLocation = new Point2D.Double(location.getX(), location.getY());
		}
		location = MyUtils.project(myrobot.location, absBearing, lastDistance);
		if(lastLocation != null) {
			deltaBearing = Utils.normalRelativeAngle(MyUtils.absoluteBearing(myrobot.lastLocation, this.location) -
													MyUtils.absoluteBearing(myrobot.lastLocation, this.lastLocation));
		}
		energy = newEnergy;
		
		// Update our 2 pattern matchers
		String enemyName = event.getName();
		StringBuffer pattern;
		if(!myrobot.theEnemyManager.funkyChickenPatterns.containsKey(enemyName)) {
			pattern = new StringBuffer("" + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)-8 + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 + (char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8);
		} else {
			pattern = (StringBuffer)myrobot.theEnemyManager.funkyChickenPatterns.get(enemyName);
		}
		pattern.insert(0, (char)(Math.round(Math.sin(newHeading - (newAbsBearing))*newLinVel)));
		myrobot.theEnemyManager.funkyChickenPatterns.put(enemyName, pattern);		
	}

	protected void enemyFired(double shotPower, String enemyName, Point2D.Double enemyShotFromLoc) {
		//myrobot.out.println(enemyName + " fired " + shotPower + " from " + (int)enemyShotFromLoc.getX() + "," + (int)enemyShotFromLoc.getY());
		if(myrobot.theMoveManager.surfDirections.size() > 2) {
			EnemyWave ew = new EnemyWave(true);
			ew.fireTime = myrobot.getTime() - 1;
			ew.bulletVelocity = MyUtils.getShotVelocity(shotPower);
			ew.distanceTraveled = ew.bulletVelocity;
			ew.shotPower = shotPower;
			ew.direction = ((Integer)myrobot.theMoveManager.surfDirections.get(2)).intValue();
			ew.directAngle = ((Double)myrobot.theMoveManager.surfAbsBearings.get(2)).doubleValue();
			ew.fireLocation = new Point2D.Double(enemyShotFromLoc.getX(), enemyShotFromLoc.getY());
			ew.fireTargetLocation = new Point2D.Double(myrobot.location.getX(), myrobot.location.getY());
			ew.enemyName = this.name;
						
			enemyWaves.add(ew);
		}
		myrobot.theEnemyManager.enemyFired(shotPower, enemyName, enemyShotFromLoc);
	}
}
