package maribo;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.HitRobotEvent;
import java.awt.Color;
import robocode.util.*;
import java.awt.geom.*;

/**
 * IotaCT - a robot by Alexander MacKenzie
 */
public class IotaCT extends AdvancedRobot
{
		double oldEnemyHeading;
		String trackName;
		int count = 0;
		boolean side;
	
	public void run() {
		
		double max = Math.max(getBattleFieldWidth(),getBattleFieldHeight());
		if (Math.random() > 0.5) {
			side = true;
		} else {
			side = false;
		}
		
		/*
		setBodyColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setGunColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setRadarColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setBulletColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setScanColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		*/
		
		setColors(Color.gray,Color.black,Color.green,Color.black,Color.green);
		
		trackName = null;
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		turnLeft(getHeading());
		ahead(getBattleFieldHeight()/2 - getY());
		turnRight(90);
		ahead(getBattleFieldWidth()/2 - getX());
		turnRight((Math.random()-.5)*180);
			
		// Robot main loop
		while(true) {	
			if (side) {
				ahead(max/3);
				turnRight(45);
				back(max/3);
				turnRight(45);
			} else {
				back(max/3);
				turnRight(45);
				ahead(max/3);
				turnRight(45);
			}
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		count++;
		if (count > (getOthers()*2)+1) {
			trackName = null;
		}
		
		if (trackName != null && !e.getName().equals(trackName)) {
			if (e.getDistance() < 100) {
				trackName = e.getName();
			} else {
				return;
			}
		}
		if (trackName == null) {
			trackName = e.getName();
		}		
		count = 0;
		
		double firePower = Math.min(3,getEnergy()/15);
		double bulletPower = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = e.getVelocity();
		oldEnemyHeading = enemyHeading;
	 
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), 
		       battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < 
		      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
		 
				predictedX = Math.min(Math.max(18.0, predictedX), 
				    battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 
				    battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(
		    predictedX - getX(), predictedY - getY()));
		if (getOthers() >= 3) {
			if (e.getName().equals(trackName) && getGunHeat() < 1) {
				setTurnRadarRightRadians(Utils.normalRelativeAngle(
		    		absoluteBearing - getRadarHeadingRadians()));
			} else {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
		} else {
			setTurnRadarRightRadians(Utils.normalRelativeAngle(
    			absoluteBearing - getRadarHeadingRadians()));
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(
		    theta - getGunHeadingRadians()));
		if (getGunHeat() == 0) {	
			fire(firePower);
		}
	}

	public void onHitRobot(HitRobotEvent e) {
		trackName = e.getName();
	}	
	
}
