package kawigi.mini;
import robocode.*;
import java.awt.geom.*;
import java.io.*;
import java.util.zip.*;
import java.awt.Color;
import java.util.*;

/**
 * Fhqwhgads - short for Fhqwhgadshgnsdhjsdbkhsdabkfabkveybvf.  Loves StrongBad, so much that her colors
 * resemble those of strongbad.
 * In reality, this is FloodMini's gun with a completely different movement (one that isn't triggered by bullet fire).
 * Version 1.1 - fixed a problem that was causing it to run extremely slow on some systems (including PEZ's, or else I probably wouldn't have fixed it
 * 				I also made it melee aware now, and upgraded the gun a little to look more like the next version of FloodHT's (0.9) logically.
 * 				Among the first MiniBots with Virtual guns!  One compiles stats continuously (like FloodMini has always done), the other only counts
 * 				waves that were fired when I fired.  Those are 'virtual guns' 0 and 2 respectively in one-on-one, 1 and 3 in melee.
 */
public class Fhqwhgads extends AdvancedRobot
{
	static int currentDirection=30;
	static double currentEnergy, lastbulletspeed, lastv, direction;
	long nextTime;
	static HashMap statsHash = new HashMap(), gunHits = new HashMap();
	static Vector ovbullets;
	static Random rand = new Random();
	
	public boolean out(double x, double y, double angle, double c)
	{
		return !(new Rectangle2D.Double(18D, 18D, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D)).contains(Math.sin(angle)*c+x, Math.cos(angle)*c+y);
	}

	public void run()
	{
		ovbullets = new Vector();
		setAdjustGunForRobotTurn(true);
		setColors(Color.red, Color.black, Color.green);
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	/*private double gaussGauss()
	{
		double v1, v2, s;
		do
		{
			v1 = rand.nextGaussian();
			v2 = rand.nextGaussian();
			s = v1*v1+v2*v2;
		}
		while (s >= 1 || s == 0);
		return Math.sqrt(-2*Math.log(s)/s)*v1;
	}*/
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double myx = getX(), myy = getY();
		double distance;
		double absbearing;
		double x = myx+Math.sin(absbearing = getHeadingRadians() + e.getBearingRadians())*(distance = e.getDistance());
		double y = myy+Math.cos(absbearing)*distance;
		long time;
		//first, the Fhqwhgads movement:
		if ((time = getTime()) >= nextTime && currentEnergy > 0)
		{
			currentDirection = -currentDirection; //(Math.random() < .5)?-30:30;
			nextTime = time+(long)(distance/lastbulletspeed*Math.abs(rand.nextGaussian()));
		}
		if (out(myx, myy, getHeadingRadians(), currentDirection))
			currentDirection = -currentDirection;
		setAhead(currentDirection);
		int[][][][][][] stats;
		int[] gunhits;
		String name;
		if (statsHash.containsKey(name = e.getName()))
		{
			stats = (int[][][][][][])statsHash.get(name);
			gunhits = (int[])gunHits.get(name);
		}
		else
		{
			try
			{
				ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(name))));
				stats = (int[][][][][][])in.readObject();
				gunhits = (int[])in.readObject();
				in.close();
			}
			catch (Exception ex)
			{
				//wall, accl, latv, distance, melee/firing, guessfactors 
				stats = new int[2][3][3][10][4][31];
				gunhits = new int[4];
			}
			statsHash.put(name, stats);
			gunHits.put(name, gunhits);
		}
		setTurnRadarLeft(getRadarTurnRemaining());
		double denergy;
		if ((denergy = currentEnergy-(currentEnergy = e.getEnergy())) > 0 && denergy <= 3)
			lastbulletspeed = 20-3*denergy;
		
		
		//accl basically ends up being 0 for not strongly accelerating/decelerating, 1 for accelerating, 2 for decelerating.
		int accl = (int)Math.round(Math.abs(lastv)-Math.abs(lastv = e.getVelocity()));
		if (accl != 0)
			accl = (accl < 0)? 1 : 2;
			
		//double eheading;
		
		int rel = 90;
		if (distance < 300)
			rel = 90+currentDirection;
		if (out(myx, myy, Math.PI+absbearing, 50) || closeToCorner() || distance > 600)
			rel = 90-currentDirection;
		setTurnRight(e.getBearing()-rel);
		
		double latvel;// = Math.sin(e.getHeadingRadians()-absbearing)*lastv;
		if ((latvel = Math.sin(e.getHeadingRadians()-absbearing)*lastv) != 0)
			direction = (latvel < 0)?-1:1;
		//my attempted stat-gun:
		
		//try using rel as the wall-relationship now.
		//the way I was doing this before turned out to be more expensive than adding more parameters to the out function.
		rel = (out(x, y, e.getHeadingRadians(), 10*lastv))? 1: 0;
		int i=0;
		int othersindex = Math.min(getOthers()-1, 1);
		while (i < ovbullets.size())
		{
			MiniBullet b = (MiniBullet)ovbullets.elementAt(i);
			//System.out.println(name + " " + b.name);
			if (name.equals(b.name))
			{
				int ind = Math.min(b.updateEnemy(x, y, time), 30);
				if (ind >= 0)
				{
					int[][] ptr;
					(ptr = stats[b.wallrel][b.accl][b.latspeed][b.dindex])[othersindex][ind]++;
					if (b.firing)
					{
						ptr[othersindex+2][ind]++;
						if (b.guess == ind)
							gunhits[othersindex]++;
						if (b.guessFO == ind)
							gunhits[othersindex+2]++;
					}
					ovbullets.removeElementAt(i);
					i--;
				}
			}
			i++;
		}
		//might end up changing this back.  Now I'm using denergy as the power:
		denergy = Math.min(Math.min(currentEnergy, getEnergy())/4, 3);
		double bulletspeed;
		int bestindex;
		int bestindexFO = bestindex = 15;
		int dindex;
		int latv;// = (int)Math.abs(latvel/3);
		int[][] current = stats[rel][accl][latv = (int)Math.abs(latvel/3)][dindex = Math.min(9, (int)(distance/10/(bulletspeed = 20-denergy*3)))];
		i=0;
		if (currentEnergy > 0)
			do
			{
				if (current[othersindex][i] > current[othersindex][bestindex])
					bestindex = i;
				if (current[othersindex+2][i] > current[othersindex+2][bestindexFO])
					bestindexFO = i;
				i++;
			}
			while(i<31);
		double realdirection;
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()+(realdirection = Math.asin(9/bulletspeed)*direction)*(((gunhits[othersindex] >= gunhits[othersindex+2]) ? bestindex : bestindexFO)/15.0-1)));
		
		MiniBullet mb;
		ovbullets.addElement(mb = new MiniBullet());
		//eliminating the parameters (and even the whole constructor) turned out to be smaller.
		//Kind of weird doing so much dereferencing, but I guess it comes out just slightly smaller than pushing everything onto the stack.
		mb.name = name;
		mb.guess = bestindex;
		mb.guessFO = bestindexFO;
		mb.latspeed = latv;
		mb.accl = accl;
		mb.dindex = dindex;
		mb.wallrel = rel;
		mb.firing = (setFireBullet(denergy) != null);
		mb.direction = realdirection;
		mb.speed = bulletspeed;
		mb.firetime = (mb.lasttime = time)+1;
		mb.startgunheading = absbearing;
		mb.startx = myx;
		mb.starty = myy;
		mb.lastx = x;
		mb.lasty = y;
	}
	
	private boolean closeToCorner()
	{
		int i=0;
		do
		{
			if (Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight()) < 200)
				return true;
			i++;
		}
		while (i < 4);
		return false;
	}
	
	public void onWin(WinEvent e)
	{
		try
		{
			Iterator keyIterator = statsHash.keySet().iterator();
			do
			{
				String name;
				ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(name = (String)keyIterator.next()))));
				out.writeObject(statsHash.get(name));
				out.writeObject(gunHits.get(name));
				out.close();
			}
			while (keyIterator.hasNext());
		}
		catch (Exception ex)
		{
		}
	}
}