package cs.s2.gun;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;

import cs.s2.Extension;
import cs.s2.Seraphim;
import cs.s2.misc.Tools;
import cs.s2.misc.Wave;
import cs.s2.stat.SplitSet;
import cs.s2.stat.StatBuffer;
import cs.s2.stat.StatBufferSet;
import cs.s2.stat.StatData;


import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;


public final class TestSword extends Extension {
	private static final int totalBin = 47;
	public static final StatBufferSet sbs = new StatBufferSet();
	private LinkedList<Wave> waves;
	
	LinkedList<Point2D.Double> ePast = new LinkedList<Point2D.Double>();
	
	Point2D.Double eLocation = null;
	StatData lastStatData = null;
	
	int lastDirection = 1;
	long lastDirectionChangeTime = 0;
	double lastLateralVelocity = 0;
	double lastVelocityChangeTime = 0;
	
	private static int shotsFired = 0;
	private static int shotsIntercepted = 0;
	private static int shotsHit = 0;
	
	public void onBulletHit(BulletHitEvent e) {
		++shotsHit;
	}
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		++shotsIntercepted;
	}
	
	public void run() {
		if(bot.getRoundNum() == 0) {
			StatBuffer buffer = new StatBuffer(totalBin);
			buffer.setHalflife(5);
			sbs.add(buffer, 1.0);
			
			/* Fast Buffers */
			/* Low Buffer */
			SplitSet set = new SplitSet();
			set.add(new double[]{ 2, 4, 6 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ 24, 48 }, 1); //Bullet Flight Time
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(10);
			sbs.add(buffer, 50);
			
			/* High Buffer */
			set = new SplitSet();
			set.add(new double[]{ 0.5, 2.5, 5.0, 7.5 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ 14, 28, 42, 56 }, 1); //Bullet Flight Time
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(15);
			sbs.add(buffer, 50);
			
			/* Slow Buffers */
			/* Low Buffer */
			set = new SplitSet();
			set.add(new double[]{ 0.5, 2.25, 6.75 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ 24, 48 }, 1); //Bullet Flight Time
			set.add(new double[]{ .05, .35 }, 3); //Velocity Change Time
			set.add(new double[]{ 0.25, 0.45, 0.65 }, 5); //Wall Forward
			set.add(new double[]{ 55 }, 4); //Distance in last x ticks
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(35);
			sbs.add(buffer, 200);
			
			/* High Buffer */
			set = new SplitSet();
			set.add(new double[]{ .5, 1.25, 2.25, 6.75 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ 14, 28, 42, 56 }, 1); //Bullet Flight Time
			set.add(new double[]{ .05, .15, .35, .45 }, 3); //Velocity Change Time
			set.add(new double[]{ .2, .4, .6, .8, 1.1 }, 5); //Wall Forward
			set.add(new double[]{ 26, 58 }, 4); //Distance in last x ticks
			set.add(new double[]{ .5 }, 6); //Wall Reverse
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(40);
			sbs.add(buffer, 200);
		}
		waves = new LinkedList<Wave>();
	}
	
	
	public void execute() {
		if(Seraphim.isChallenge) return;
		//Update and check waves!
		if(eLocation != null) {
			long time = bot.getTime();
			
			Iterator<Wave> it = waves.iterator();
			while(it.hasNext()) {
				if(it.next().check(eLocation, time, sbs, true)) {
					it.remove();
				}
			}
			
			
		}
	}
	
	public void onPaint(Graphics2D g) {
		if(Seraphim.isChallenge) return;
		if(bot == null) return;
		
		if(waves != null) {
			long time = bot.getTime();
			for(Wave w : waves) {
				if(!w.realWave) continue;
				double d = w.distance(time);
				g.setColor(Color.WHITE);
				g.drawOval((int)(w.x-d), (int)(w.y-d), (int)(d*2), (int)(d*2));
				Line2D line = new Line2D.Double(Tools.project(w,w.baseAngle,d+10),Tools.project(w,w.baseAngle,d-10));
				g.draw(line);
				line = new Line2D.Double(Tools.project(w,w.baseAngle + w.escapeAngle,d+10),Tools.project(w,w.baseAngle + w.escapeAngle,d-10));
				g.draw(line);
				line = new Line2D.Double(Tools.project(w,w.baseAngle - w.escapeAngle,d+10),Tools.project(w,w.baseAngle - w.escapeAngle,d-10));
				g.draw(line);
			}
		}
		
		if(lastStatData == null) return;
		double[] bins = sbs.getCombinedScoreData(lastStatData);
		double max = 0;
		for(double d : bins) if(d > max) max = d;
		
		for(int i=0; i<bins.length; ++i) {
			g.setColor(Color.WHITE);
//			if(lastIndex == i)
//				g.setColor(Color.GREEN);
			if((bins.length-1)/2 == i)
				g.setColor(Color.RED);
			g.drawRect(20+i*8, 20, 6, (int)(bins[i]/max*50));
		}
	}
	
	public static final String[] offsetAgainst = new String[] {
		"GeomancyBS","uCatcher","BulletCatcher","XanderCat","EnergyDome","MoxieBot"
	};
	
	static boolean checkIsEnemyBulletCatcher = false;
	static boolean isEnemyBulletCatcher = false;
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(Seraphim.isChallenge) return;
		if(bot.getEnergy() < 1e-4) return;
		
		if(!checkIsEnemyBulletCatcher) {
			for(String s : offsetAgainst) {
				if(e.getName().contains(s)) {
					isEnemyBulletCatcher = true;
					break;
				}
			}
			
			if(isEnemyBulletCatcher) {
				System.out.println("\tCheeky Bastard Detected, using offset.");
			}
			checkIsEnemyBulletCatcher = true;
		}
		
		long time = e.getTime();
		
		double eAbsAngle = bot.getHeadingRadians() + e.getBearingRadians();
		double eDistance = e.getDistance();
		double eVelocity = e.getVelocity();
		double eLateralVelocity = eVelocity * Math.sin(e.getHeadingRadians() - eAbsAngle);
		
		Point2D.Double myLocation = new Point2D.Double(bot.getX(), bot.getY());
		eLocation = Tools.project(myLocation, eAbsAngle, eDistance);
		ePast.addFirst(eLocation);
		if(ePast.size() > 16) ePast.pollLast();
		
		boolean fired = false;
		//double bulletPower = 3.0;
		double bulletPower = bulletPower(e);
		
		if(bot.getGunHeat() < 0.001) {
			if(bot.getGunTurnRemainingRadians() < Math.PI/128.0) {
				if(bulletPower < bot.getEnergy()) {
					Bullet b = bot.setFireBullet(bulletPower);
					if(b != null) {
						++shotsFired;
						bulletPower = b.getPower();
						fired = true;
					}
				}
			}
		}
		
		double bulletSpeed = Rules.getBulletSpeed(bulletPower);
		int direction = Tools.sign(eLateralVelocity);
		if(eLateralVelocity == 0) direction = lastDirection;
		
		if(direction != lastDirection) {
			//System.out.println();
			lastDirectionChangeTime = time;
		}
		
		if(Math.abs(lastLateralVelocity - eLateralVelocity) > 0.5) {
			lastVelocityChangeTime = time;
		}
		
		double fWall = getWallDistance(myLocation, eAbsAngle, eDistance, direction);
		double bWall = getWallDistance(myLocation, eAbsAngle, eDistance, -direction);
		
		double BFT = eDistance/bulletSpeed;
		/* TODO */
		double[] statData = new double[] {
			/* 0 */ Math.abs(eLateralVelocity),
			/* 1 */ BFT,
			/* 2 */ (time - lastVelocityChangeTime) / BFT,
			/* 3 */ (time - lastDirectionChangeTime) / BFT,
			/* 4 */ eLocation.distance(ePast.peekLast()),
			/* 5 */ fWall,
			/* 6 */ bWall,
//			lastLateralVelocity - eLateralVelocity,
//			bot.getGunHeat()/bot.getGunCoolingRate(),
		};
		/* TODO */
		
		//Robot Scanned, we make a wave!
		Wave w = new Wave(myLocation, eAbsAngle, bulletSpeed, direction, time + 1);
		w.realWave = fired;
		w.data = statData;
		waves.add(w);
		
		lastDirection = direction;
		lastLateralVelocity = eLateralVelocity;
		
		//double angleOffset = direction * guessfactor * newWave.maxEscapeAngle();
		lastStatData = new StatData(statData, 0);
		
		double gf = sbs.getBestGF(lastStatData);
		double aOffset = gf * w.escapeAngle;
		
		//Minimal Angle to screw up uCatcher
		if(isEnemyBulletCatcher)
			aOffset += Math.atan(18.0/eDistance) * 0.06125 * (Math.random() > 0.5 ? 1 : -1);
		
		bot.setTurnGunRightRadians(Utils.normalRelativeAngle(eAbsAngle - bot.getGunHeadingRadians() + aOffset));
	}
	
	public void onRoundEnd() {
		if(Seraphim.isChallenge) return;
		System.out.printf("Intecepted %%: %.2f%%  %d\\%d\n",
				(double)shotsIntercepted/(double)shotsFired*100.0,
				shotsIntercepted,shotsFired);
		System.out.printf("Hit %%: %.2f%%  %d\\%d\n",
				(double)shotsHit/(double)shotsFired*100.0,
				shotsHit,shotsFired);
	}
	
	private final double bulletPower(ScannedRobotEvent e) {
		double power = 1.95;
		double myEnergy = bot.getEnergy();
		double enemyEnergy = e.getEnergy();
		double distance = e.getDistance();
		if(myEnergy < 15.0 && enemyEnergy > myEnergy) power = 1.0;
		if(myEnergy < 25.0 && enemyEnergy > myEnergy) power = 1.5;
		if(myEnergy < 1.0) {
			power = 0.0;
			if(myEnergy < 1.0 && enemyEnergy / 2.0 < myEnergy)
				power = 0.1;
		}
		power = Math.min(power, enemyEnergy / 4.0);
		if(enemyEnergy < 0.1) power = 0.1;
		if(distance < 120.0) power = 3.0;
		
		power = Math.round(power*20.0)/20.0;
		if((power*20) % 2 == 0)
			power += 0.05;
		if(power >= 3)
			power = 3.0;
		
		return power;
	}
}
