package tjk.utils;

import tjk.universe.Universe;

/**
 * tjkUtil - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class tjkUtil
{
	
	static final double[] no = {-1.0};
	
	public static double[][] distArrayForward;
	public static double[][] distArrayBackward;
	
	// Initialize	
	public static void init()
	{
		/*
		final int array1 = (int)Rules.MAX_VELOCITY+1;
		final int array2 = (int)(Universe.bfDiag()/Rules.getBulletSpeed(Rules.MAX_BULLET_POWER)) + 5;
		
		distArrayForward = new double[array1][array2];
		distArrayBackward = new double[array1][array2];
		
		//forward array building.
		for (int startV = 0; startV < array1; startV++)
		{
			double v = startV;
			double dist_travelled = 0.0;
			for (int timeStep = 0; timeStep < array2; timeStep++)
			{
				distArrayForward[startV][timeStep] = dist_travelled;
				dist_travelled += v;
				if ( Double.compare(v,Rules.MAX_VELOCITY) < 0 )
				{
					v += Rules.ACCELERATION;
					v = Math.min(v,Rules.MAX_VELOCITY);
				}
			}
		}
		
		// back array building...
		for (int startV = 0; startV < array1; startV++)
		{
			double v = startV;
			double dist_travelled = 0.0;
			for (int timeStep = 0; timeStep < array2; timeStep++)
			{
				distArrayBackward[startV][timeStep] = dist_travelled;
				dist_travelled += v;
				if ( Double.compare(v,0) > 0 )
				{
					v -= Rules.DECELERATION;
				}
				else if ( Double.compare(v,-Rules.MAX_VELOCITY) > 0 )
				{
					v -= Rules.ACCELERATION;
					v = Math.max(v,-Rules.MAX_VELOCITY);
				}
			}
		}
		*/
	}
	
	/**
	 * Returns a half-life array or locates an already calculated one.
	 */
	public static double[] halfLifeArray(double HL)
	{
		// No zero or negative half lives!!!
		if ( Double.compare(HL,0.0) <= 0.0 )
		{
			int numRounds = Universe.getNumRounds();
			double[] answer = new double[numRounds+1];
		
			for (int i = 0; i <= numRounds; i++ )
			{
				answer[i] = 1.0;
			}
			
			return answer;	
		}
		
		int numRounds = Universe.getNumRounds();
		double[] answer = new double[numRounds+1];
		
		for (int i = 0; i <= numRounds; i++ )
		{
			answer[i] = Math.pow(0.5,((double)i)/HL);
		}

		return answer;
	}
	
	// Code adapted from Paul Bourke:
	// http://local.wasp.uwa.edu.au/~pbourke/geometry/sphereline/raysphere.c
	//
	//  Adapted by REAS: http://www.openprocessing.org/portal/?userID=54
	//			@ Open Processing: http://www.openprocessing.org/visuals/?visualID=8009
	//
	//	Further adapted by tkiesel
	//
	//   License: CC-by-sa 3.0 http://creativecommons.org/licenses/by-sa/3.0/us/
	public static double[] circleLineIntersect(double x1, double y1, double x2, double y2, double cx, double cy, double cr ) {
		double dx = x2 - x1;
		double dy = y2 - y1;
		double a = dx * dx + dy * dy;
		double b = 2 * (dx * (x1 - cx) + dy * (y1 - cy));
		double c = cx * cx + cy * cy;
		c += x1 * x1 + y1 * y1;
		c -= 2 * (cx * x1 + cy * y1);
		c -= cr * cr;
		double bb4ac = b * b - 4 * a * c;
		
		//println(bb4ac);
		
		if (bb4ac < 0) {  // Not intersecting
			return no;
		}
		else {
     
			double mu = (-b + Math.sqrt( b*b - 4*a*c )) / (2*a);
			double ix2 = x1 + mu*(dx);
			double iy2 = y1 + mu*(dy);
			mu = (-b - Math.sqrt(b*b - 4*a*c )) / (2*a);
			double ix1 = x1 + mu*(dx);
			double iy1 = y1 + mu*(dy);
			
			// The intersection points
			//System.out.println(ix1 + " " + iy1);
			//System.out.println(ix2 + " " + iy2);
			
			if ( (ix1 > x1 && ix1 > x2) || (ix1 < x1 && ix1 < x2) || (iy1 > y1 && iy1 > y2) || (iy1 < y1 && iy1 < y2) )
			{
				//not test1
				if ( (ix2 > x1 && ix2 > x2) || (ix2 < x1 && ix2 < x2) || (iy2 > y1 && iy2 > y2) || (iy2 < y1 && iy2 < y2) )
				{
					//not test2 either
					return no;
				}
				else
				{
					//test2 but not test1
					//System.out.println("test2 but not test1");
					double[] ans = {1.0,ix2,iy2};
					return ans;
				}
			}
			else
			{
				//test1
				if ( (ix2 > x1 && ix2 > x2) || (ix2 < x1 && ix2 < x2) || (iy2 > y1 && iy2 > y2) || (iy2 < y1 && iy2 < y2) )
				{
					//test1 but not test2
					//System.out.println("test1 but not test2");
					double[] ans = {1.0,ix1,iy1};
					return ans;
				}
				else
				{
					//test1 and test2
					//System.out.println("test1 and test2");
					double[] ans = {1.0,ix1,iy1,ix2,iy2};
					return ans;
				}
			}
			/*
			if (Point2D.distanceSq(testX, testY, ix1, iy1) < Point2D.distanceSq(x1, y1, x2, y2) || Point2D.distanceSq(testX, testY, ix2, iy2) < Point2D.distanceSq(x1, y1, x2, y2)) {
				// Fix Box!!!			
				if ( (ix1 >= x1 && ix1 <= x2) && (iy1 >= y1 && iy1 <= y2) )
				{
					if ( (ix2 >= x1 && ix2 <= x2) && (iy2 >= y1 && iy2 <= y2) )
					{
						System.out.print("Two points! ");
						System.out.print(ix1 + " " + iy1 + " ");
						System.out.println(ix2 + " " + iy2);
						double[] ans = {1.0,ix1,iy1,ix2,iy2};
						return ans;
					}
					else
					{
						System.out.println("First Point: " + ix1 + " " + iy1);
						double[] ans = {1.0,ix1,iy1};
						return ans;
					}
				}
				else 
				{
					System.out.println("Second Point: " + ix2 + " " + iy2);
					double[] ans = {1.0,ix2,iy2};
					return ans;
				}
			} else {
				System.out.println("Nothing: " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + ix1 + " " + iy1 + " " + ix2 + " " + iy2);
				return no;
			}
			*/
		}
	}
	
	
}
		