/***************************************************************************************
*  Robot:  nano.TimCat
*  Author: Liuyang
*  Create: 2003.05.10
*  Tips:   1v1 docility cat.
*......................................................................................
*  v0.10 - 2003.05.10 - 243 - Create bot, move dodge wall.
*  v0.11 - 2003.05.12 - 240 - Fix any bugs, capabiliy.
*  v0.12 - 2003.05.16 - 242 - Fix moving method and so on.
*  v0.13 - 2003.07.21 - 246 - Moving conditions this battle field width and height.
****************************************************************************************/
package timmit.nano;

import robocode.*;
import java.awt.geom.*;
import java.awt.Color;

public class TimCat extends AdvancedRobot{
	static double epEnergy = 100;
	//static Rectangle2D.Double rect = new Rectangle2D.Double(50,50,750,550);	//codesize = 22//
	
	public void run(){
		setColors(Color.green,Color.green,Color.white);
		do{
			turnRadarRightRadians(1);
		}while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){//------------- My cat found mouse -------------//
		
		//ROBOT TURN//
		int direction = Math.random() > 0.6 ? 1 : -1;
		if(epEnergy != (epEnergy = e.getEnergy())){
			setTurnRightRadians(Math.asin(Math.sin(e.getBearingRadians() + Math.PI/2)) - Math.PI/12 * direction);
			double dist = (e.getDistance()/3 + 30) * direction;
			if(!new Rectangle2D.Double(25,25,getBattleFieldWidth()-50,getBattleFieldHeight()-50).contains(
						getX() + Math.sin(getHeadingRadians() + getTurnRemainingRadians()) * dist,
						getY() + Math.cos(getHeadingRadians() + getTurnRemainingRadians()) * dist)){
				dist = -dist;
			}
			setAhead(dist);
		}
		
		//GUN TURN//
		setTurnGunRightRadians(Math.asin(Math.sin(getHeadingRadians() + e.getBearingRadians() - getGunHeadingRadians())));
		
		//SHOOT MOUSE//
		if(getEnergy()>3) setFire(e.getEnergy()/4);
		
		//RADAR TURN//
		setTurnRadarLeftRadians(getRadarTurnRemaining());
		scan();
	}
}