package bots;

import robocode.*;
import robocode.util.Utils;

public class UberBot extends AdvancedRobot {

    double power = 3, dir = 100;
    double direction, speed;

    public void run() {


        setAdjustGunForRobotTurn(true);
        //setAdjustGunForRobotTurn(false);
        setAdjustRadarForGunTurn(true);
        setTurnRadarRight(Double.POSITIVE_INFINITY);

        while (true) {
            scan();
            execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        direction = getHeadingRadians() + e.getBearingRadians();
        setTurnRadarRightRadians(Utils.normalRelativeAngle(direction - getRadarHeadingRadians()));
        speed = 0.85 * speed + 0.15* e.getVelocity();
        setFire(power);
        double x = e.getHeadingRadians() - direction;
        setTurnGunRightRadians(Utils.normalRelativeAngle(direction - getGunHeadingRadians()) + speed * Math.sin(x) / Math.sqrt(e.getDistance()));
        setTurnRight(e.getBearing() + 95);

    }

    public void onBulletHit(BulletHitEvent event) {

        power += 0.3;
		setBack(dir);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        //setBack(dir * Math.random());
		
		setBack(dir=-dir);
        power -= 0.2;

    }

    public void onHitByBullet(HitByBulletEvent e) {
        //setBack(dir * Math.random());
		setBack(dir=-dir);
    }

    public void onHitWall(HitWallEvent e) {
        setBack(dir=-dir);
		setBack(dir);
    }
}
												
