package mn.micro.perceptual;

import static java.lang.Double.NEGATIVE_INFINITY;
import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.PI;
import static java.lang.Math.asin;
import static java.lang.Math.atan2;
import static java.lang.Math.cos;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.Math.sin;
import static java.lang.Math.sqrt;
import static robocode.Rules.MAX_BULLET_POWER;
import static robocode.Rules.MAX_VELOCITY;
import static robocode.Rules.MIN_BULLET_POWER;
import static robocode.Rules.getBulletSpeed;
import static robocode.util.Utils.normalRelativeAngle;

import java.util.ArrayList;
import java.util.List;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Mimic extends AdvancedRobot {

    @Override
    public void run() {
	setAdjustRadarForRobotTurn(true);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	while (true) {
	    turnRadarRightRadians(POSITIVE_INFINITY);
	}
    }

    @Override
    public void onScannedRobot(final ScannedRobotEvent event) {
	final double headOnBearing = event.getBearingRadians() + getHeadingRadians();

	// radar
	final double turnRadar = normalRelativeAngle(headOnBearing - getRadarHeadingRadians());
	setTurnRadarRightRadians(turnRadar + (turnRadar >= 0 ? PI / 8 : -PI / 8));

	// movement
	final double destinationDistanceX = getBattleFieldWidth() - sin(headOnBearing) * event.getDistance() - getX() * 2;
	final double destinationDistanceY = getBattleFieldHeight() - cos(headOnBearing) * event.getDistance() - getY() * 2;
	double destinationDistance = sqrt(destinationDistanceX * destinationDistanceX + destinationDistanceY * destinationDistanceY);
	destinationDistance = destinationDistance > 0.001 ? destinationDistance : 0;
	double turn = (destinationDistance > 0 ? atan2(destinationDistanceX, destinationDistanceY) : event.getHeadingRadians()) - getHeadingRadians();
	double ahead = POSITIVE_INFINITY;
	if (cos(turn) < 0) {
	    turn -= PI;
	    ahead = NEGATIVE_INFINITY;
	}
	setTurnRightRadians(normalRelativeAngle(turn));
	setAhead(ahead);
	setMaxVelocity(destinationDistance);

	// energy management
	double bulletPower = max(min(2, getEnergy() / 40), MIN_BULLET_POWER);
	if (event.getDistance() < 85) {
	    bulletPower = MAX_BULLET_POWER;
	}
	if (getEnergy() > bulletPower + 0.0101) {
	    setFire(bulletPower);
	}

	// gun
	final List<Object> randomList = new ArrayList<Object>();
	for (int i = 0; i < 11; ++i) {
	    randomList.add(getEnergy());
	    randomList.add(getRoundNum());
	    randomList.add(event.getName());
	}
	setTurnGunRightRadians(normalRelativeAngle(headOnBearing + asin(MAX_VELOCITY / getBulletSpeed(bulletPower)) * randomList.hashCode() / Integer.MAX_VALUE - getGunHeadingRadians()));
    }
}