// MirrorMicro
// (C) 2007 Stelokim
//

package stelo;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import robocode.*;
import robocode.util.Utils;

public class MirrorMicro extends AdvancedRobot {
	private static Point2D robotLocation;
	
//	private static int ticksSinceMyFire = 0;
//	private static double smallestDiff;
//	private static double smallestDiffReverse;
//	private static double matchedSign = 1.0;
	
	private static double enemyBulletPower = 0.1;
	private static double energyDrop = 0;
//	private static int ticksSinceDirection = 0;
	
	private static double enemyBulletBearing;
	private static double lastEnemyEnergy;
	
//	private static boolean aiming;
			
//	private static int hitRobotCount = 0;
	private static double lateralDirection;
//	private static double lastBearingOffset;

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);

		do {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double absBearing = e.getBearingRadians() + getHeadingRadians();
		double enemyDistance;
		Point2D enemyLocation;
		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing
				- getRadarHeadingRadians()) * 2); // 2 original

		robotLocation = new Point2D.Double(getX(), getY());
		enemyDistance = e.getDistance();
		enemyLocation = new Point2D.Double(getX() + Math.sin(absBearing) * enemyDistance, getY() + Math.cos(absBearing) * enemyDistance);
				
		// movement
		goTo(new Point2D.Double(getBattleFieldWidth() - enemyLocation.getX(), getBattleFieldHeight() - enemyLocation.getY()));
						
		// targeting
		double bulletPower;
		double enemyVelocity = e.getVelocity();
				
		energyDrop = lastEnemyEnergy - e.getEnergy();
		if (energyDrop >= 0.1 && energyDrop <= 3) {
			enemyBulletPower = energyDrop;
		}
		bulletPower = enemyBulletPower;
			
		//bulletPower = limit(0.1, bulletPower, (enemyDistance < 100 || getOthers() > 5 || smallestDiff < 1) ? 3.0 : 2.0);
		bulletPower = Math.min(bulletPower, e.getEnergy() / 5.0 );
		bulletPower = limit(0.1, bulletPower, 3.0);

		double bearingOffset = 0;						
	
		if (enemyVelocity != 0) {
			lateralDirection = Math.signum(enemyVelocity * Math.sin(getHeadingRadians() - absBearing));
		}
		
		Wave wave = new Wave(this);
		wave.gunLocation = new Point2D.Double(getX(), getY());
		Wave.targetLocation = enemyLocation;
		wave.lateralDirection = lateralDirection;
		
		wave.bulletPower = enemyBulletPower;
		wave.bearing = absBearing;
		addCustomEvent(wave);
					
		setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + wave.lastBearingOffset()));
		if (getEnergy() > bulletPower) {
			setFire(bulletPower);
		}
			
		lastEnemyEnergy = e.getEnergy();
	}

	static class Wave extends Condition {
		static Point2D targetLocation;

		double bulletPower;
		Point2D gunLocation;
		double bearing;
		double lateralDirection;

		private AdvancedRobot robot;
		private double distanceTraveled;
		static double guessAngle;
	
		Wave(AdvancedRobot _robot) {
			this.robot = _robot;
		}
	
		public boolean test() {
			// advance
			distanceTraveled += 20.0 - 3.0 * bulletPower;
			
			// has arrived?
			if (distanceTraveled > gunLocation.distance(targetLocation) - 18) {
				guessAngle = Utils.normalRelativeAngle(absoluteBearing(gunLocation, targetLocation) - bearing) * lateralDirection;
				robot.removeCustomEvent(this);
			}
			return false;
		}

		public double lastBearingOffset() {
			return guessAngle * lateralDirection;
		}
	}			

//    public void onHitByBullet(HitByBulletEvent e) {
//		if (getOthers() <= 1)
//			turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
//	}

//	public void onSkippedTurn(SkippedTurnEvent e) {
//		out.println("SkippedTurn at: " + e.getTime());
//	}

//	public void onHitByBullet(HitByBulletEvent e) {
//		enemyBulletBearing = e.getHeadingRadians() + absBearing;
//	}
						
	private void goTo(Point2D destination) {
		double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation,
				destination)
				- getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
		
		setTurnRightRadians(turnAngle);
		setAhead(robotLocation.distance(destination)
				* (angle == turnAngle ? 1 : -1));
	}

	private static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY()
				- source.getY());
	}

	public static double limit(double min, double value, double max) {
		return Math.max(min, Math.min(value, max));
	}
}
																																													