package dmp.nano;
import robocode.*;
import java.awt.Color;

/** 					Eve - a robot by Daniel Pereira
 * 		---------------------------------------------------------------
 *
 * Beyond Eve
 *	- Eve is a bot with pattern machting gun turn and dodge movement.
 * 		---------------------------------------------------------------
 *
 * Winner Versions
 *  - Version 1.1 (codesize 249)  9/08/2002: Two   times MiniBot Challenge Nano 1-on-1 champion.
 *  - Version 1.2 (codesize 248)  9/22/2002: One   time  MiniBot Challenge Nano 1-on-1 champion.
 *	- Version 2.3 (codesize 248) 10/16/2002: Three times MiniBot Challenge Nano 1-on-1 champion.
 * 		---------------------------------------------------------------
 *
 * Version 3.41: 11/23/2002
 *	- Pattern machtching gun.
 *	- Dodge movement.
 *	- Energy saving fire power.
 *  - 1-on-1 elite.
 *
 *  Note: A small downgrade just to be sure it's in the champion form.
 * 		---------------------------------------------------------------
 *
 * Special thanks to:
 * 	- Frederico Schuh who make me know about this great game.
 *  - Jan Schrader and his Lemon.	(Radar movement)
 *  - Michael Dorgan and his UDTNB.	(Basic gun turn and shot detector codesize trick)
 *	- Insectoid and his Moby.		(Ideas on how to improve my gun)
 * 	- Robocode Repository and all that great community.
 */
public final class Eve extends AdvancedRobot
{
	private static double avgAim1, bullet1;	// Enemy average movement.
	private static double avgAim2;			// Removed the need of the aimFactor var. :)

	private static double enemyEnergy;		// Shot detection var.
	private static double direction;		// Eve movement direction and distance.
	private static int	  dodge;			// Mod distance from the tracked bullet.

	/**
	 * onScannedRobot: What to do function, almost everything goes here.
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		// Bearing is bulletPower here.
		double bearing = enemyEnergy - (enemyEnergy = e.getEnergy());
		// Shot detector grabed from UDTNB 1.1 (Mike Dorgan).
		if ((Math.abs(bearing - 1.501)) < 1.5 && Math.abs(getDistanceRemaining()) <= 16)
		{
			// Get the distance and bullet speed to dodge.
			dodge = Math.min(dodge, (int)(e.getDistance()/(20 - 3*bearing)));
		}

		// Each round we remove from de distance the bullet traveled space.
		if (dodge-- < 12)
		{
			onHitWall(null);	// There's a setAhead hidden here.
		}
		// Traditional 90 movement.
		setTurnRightRadians((bearing = e.getBearingRadians()) + Math.PI/2);
		
		// Radar turn grabed from Lemon 2.3 (Jan Schrader).
		setTurnRadarRightRadians(Math.tan((bearing += getHeadingRadians()) - getRadarHeadingRadians())*3);

		// Gun turn, in linear form. Eve 2.3 machine gun.
		setTurnGunRightRadians(Math.sin(bearing - getGunHeadingRadians() + (avgAim1 + 2*avgAim2)/(3*11*10)));
		
		// Gun powder.
		// The lead have been designed to bullet power 3 so fire this kind of bullet as soon as possible.
		if (setFireBullet(1425/e.getDistance()) != null)
		{
			avgAim2 = avgAim1;			// Clear the leading aim in two turns.
			avgAim1	= 0;				// So it will not be easily fooled by multi strategy bots.
			bullet1 = getGunHeat();		// Number of ticks until next shot.
		}
		// Patented pattern matching in NanoBot form.
		avgAim1 += ((e.getVelocity()/bullet1) * Math.sin(e.getHeadingRadians() - bearing));
	}


	/**
	 * onHitWall: skip from it as soon as possible.
	 */
	public void onHitWall(HitWallEvent e)
	{
		setAhead((direction = -direction));
		dodge = 127;		// Reset (turn off) the bullet tracking.
	}


	/**
	 * run: nothing to see here.
	 */
	public void run()
	{
		// Wide scan until you find a target.
		do { turnRadarLeftRadians(direction = -128); } while(true);
	}
}
