/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.util.Collections;
import robocode.ScannedRobotEvent;
import simonton.dc.Cluster;
import simonton.dc.FutureFilter;
import simonton.dc.MyTree;
import simonton.dc.WeightedCombinationDistancer;
import simonton.segments.Dimension;
import simonton.utils.FastMath;
import simonton.waves.LogStats;
import simonton.waves.Wave;
import simonton.waves.WaveStatistician;

public class DCStatistician
extends WaveStatistician {
    private int minCluster;
    private int maxCluster;
    private Dimension[] dimensions;
    private MyTree history;
    private ScannedRobotEvent scan;
    private WeightedCombinationDistancer distancer;
    private double[] maskMetric;
    private double[] lastState;
    private double[] hitState;
    private double hitGf;
    private FutureFilter futureFilter = new FutureFilter();

    public DCStatistician(int minCluster, int maxCluster, int maxDensity, int maxDepth, int numConstantDimension, boolean recordOnDiscovery, boolean updateOnDiscovery, Dimension[] dimensions) {
        super(recordOnDiscovery, updateOnDiscovery);
        this.minCluster = minCluster;
        this.maxCluster = maxCluster;
        this.dimensions = dimensions;
        this.history = new MyTree(dimensions.length, maxDensity, 1.0, maxDepth);
        int numVariable = dimensions.length - numConstantDimension;
        this.distancer = new WeightedCombinationDistancer(numVariable);
        this.maskMetric = new double[1 << numVariable];
    }

    public void offtick() {
    }

    @Override
    public void setAimingState(Wave wave) {
        this.lastState = new double[this.dimensions.length];
        int i = this.lastState.length;
        while (--i >= 0) {
            this.lastState[i] = this.dimensions[i].getCoordinate(this, this.scan, wave);
            assert (!(this.lastState[i] < 0.0) && !(this.lastState[i] > 1.0));
        }
        wave.firingState = this.lastState;
    }

    @Override
    public void setStats(Wave wave, boolean recalc) {
        assert (wave.firingState != null);
        if (!recalc && wave.stats != null) {
            return;
        }
        LogStats stats = new LogStats(wave);
        wave.stats = stats;
        if (this.history.size() == 0) {
            Cluster.Point headOn = new Cluster.Point(0.0, null);
            stats.setLog(Collections.singleton(headOn));
            return;
        }
        int size = this.getClusterSize();
        stats.setLog(this.history.buildCluster((double[])wave.firingState, size, this.distancer, Cluster.NON_FILTER));
    }

    @Override
    public void run() {
        super.run();
        this.scan = null;
        this.distancer.printWeights();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
        this.scan = e;
    }

    @Override
    protected void recordStat(Wave wave, double gf) {
        this.hitGf = gf;
        this.hitState = (double[])wave.firingState;
        Cluster.Point added = this.history.add(this.lastState, gf);
        this.futureFilter.setCutoff(added.id);
    }

    private int getClusterSize() {
        return FastMath.ceil(FastMath.bound(Math.sqrt(this.history.size()), (double)this.minCluster, (double)this.maxCluster));
    }
}

