/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.vector;

import pedersen.core.Teammate;
import pedersen.movement.vector.MovementMethodVector;
import pedersen.movement.vector.MovementMethodVectorBase;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Vector;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.physics.constant.VectorImpl;
import pedersen.util.Constraints;

public class MovementMethodVectorRobotImpl
extends MovementMethodVectorBase {
    private static final MovementMethodVector singleton = new MovementMethodVectorRobotImpl();
    private static final double alwaysOnRangeDefault = 80.0;
    private static final double alwaysOnPowerDefault = 32.0;
    private static final double fieldMagnitudeDefault = 400.0;

    private MovementMethodVectorRobotImpl() {
        super(400.0, 80.0, 32.0);
    }

    public static MovementMethodVector getInstance() {
        return singleton;
    }

    @Override
    public DistanceVector getVector() {
        HasPosition snapshot;
        Position vectorSum = PhysicsConstants.anchorPosition;
        Vehicle combatant = super.getCombatantSnapshot();
        for (Target target : TargetBank.getInstance().getActiveTargets()) {
            snapshot = target.getSnapshot();
            if (snapshot == null) continue;
            vectorSum = vectorSum.addVector(this.getFieldVector(combatant, snapshot));
        }
        for (Teammate teammate : Teammate.getActiveTeammates()) {
            snapshot = teammate.getSnapshot().getPosition();
            if (snapshot == null) continue;
            vectorSum.addVector(this.getFieldVector(combatant, snapshot));
        }
        DistanceVector distanceVector = PhysicsConstants.anchorPosition.getRelativeDistanceVector(vectorSum, combatant);
        return distanceVector;
    }

    private Vector getFieldVector(HasPosition subject, HasPosition fieldPosition) {
        return new VectorImpl((HasDirection)fieldPosition.getPosition().getBearing(subject), this.getFieldMagnitude(fieldPosition.getPosition().getDistance(subject).distance() - Constraints.vehicleRadius));
    }
}

