/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pedersen.core.Controller;
import pedersen.core.Foundation;
import pedersen.core.GameState;
import pedersen.core.Teammate;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWaveBank;
import pedersen.divination.TeammateBullet;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.SnapshotImpl;
import pedersen.physics.constant.WaveImpl;
import pedersen.systems.ScannerSubsystem;
import pedersen.systems.TurretSubsystem;
import pedersen.team.communication.Communique;
import pedersen.team.communication.CommuniqueBase;
import pedersen.team.communication.CommuniqueCancelBulletWave;
import pedersen.team.communication.CommuniqueEnemyScan;
import pedersen.team.communication.CommuniqueEnemyWave;
import pedersen.team.communication.CommuniqueFactory;
import pedersen.team.communication.CommuniqueMyBullet;
import pedersen.team.communication.CommuniqueMyBulletTarget;
import pedersen.team.communication.CommuniqueMyRadarTarget;
import pedersen.team.communication.CommuniqueNotAvailable;
import pedersen.team.communication.CommuniqueOther;
import pedersen.team.communication.CommuniquePersonalData;
import pedersen.team.communication.CommuniqueSuggestedBulletTarget;
import pedersen.team.communication.CommuniqueSuggestedRadarTarget;
import pedersen.util.ExceptionHandler;
import robocode.MessageEvent;

public class CommunicationSubsystem
extends DebuggableBase {
    private List<Communique> inbound = new ArrayList<Communique>();
    private List<Communique> outbound = new ArrayList<Communique>();
    private static CommunicationSubsystem singleton = new CommunicationSubsystem();
    public static boolean debug = false;

    private CommunicationSubsystem() {
    }

    public static CommunicationSubsystem getInstance() {
        return singleton;
    }

    public void process(MessageEvent e) {
        this.inbound.addAll(CommuniqueFactory.translateMessage(e));
    }

    public Iterable<Communique> getTeamMessages() {
        return this.inbound;
    }

    public void prepareCommunique(Communique communique) {
        this.outbound.add(communique);
    }

    public void transmitCommuniques() {
        for (Teammate teammate : Teammate.getLivingTeammates()) {
            try {
                Foundation.getInstance().sendMessage(teammate.getName(), CommuniqueFactory.packageCommuniques(this.outbound));
            }
            catch (IOException ex) {
                ExceptionHandler.handleException(ex);
            }
        }
        this.outbound.clear();
    }

    public void turnTeardown() {
        this.inbound.clear();
        this.transmitCommuniques();
        this.outbound.clear();
    }

    public void processTeamMessages() {
        for (Communique c : this.inbound) {
            CommuniqueBase na;
            Target target;
            WaveImpl wave;
            SnapshotImpl snapshot;
            Teammate teammate = Teammate.findByName(c.getSender());
            if (teammate == null) {
                super.console("Teammate [" + c.getSender() + "] was rejected as unrecognized.");
                continue;
            }
            if (c instanceof CommuniquePersonalData) {
                CommuniquePersonalData pd = (CommuniquePersonalData)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " is sending his personal data.");
                snapshot = new SnapshotImpl(GameState.getInstance().getRound(), pd.time, pd.x, pd.y, pd.h, pd.v, pd.e);
                teammate.update(snapshot);
                continue;
            }
            if (c instanceof CommuniqueMyBullet) {
                CommuniqueMyBullet bo = (CommuniqueMyBullet)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " fired a bullet in turn " + bo.time);
                new TeammateBullet(bo.time, bo.x, bo.y, bo.h, bo.v);
                continue;
            }
            if (c instanceof CommuniqueCancelBulletWave) {
                CommuniqueCancelBulletWave bx = (CommuniqueCancelBulletWave)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " cancelled a bullet in turn " + bx.time);
                wave = new WaveImpl(bx.time, bx.x, bx.y, 0.0);
                CombatWaveBank.getInstance().cancelWavesViaComms(wave);
                continue;
            }
            if (c instanceof CommuniqueEnemyScan) {
                CommuniqueEnemyScan es = (CommuniqueEnemyScan)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " sent scan of " + es.name);
                snapshot = new SnapshotImpl(GameState.getInstance().getRound(), es.time, es.x, es.y, es.h, es.v, es.e);
                Controller.getInstance().processRobotSnapshot(es.time, es.name, snapshot, false);
                continue;
            }
            if (c instanceof CommuniqueEnemyWave) {
                CommuniqueEnemyWave ew = (CommuniqueEnemyWave)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " sent wave origin at (" + ew.x + ", " + ew.y + ").");
                wave = new WaveImpl(ew.time, ew.x, ew.y, ew.v);
                Target target2 = TargetBank.getInstance().findByPosition(wave);
                if (target2 == null) continue;
                target2.fire(wave);
                continue;
            }
            if (c instanceof CommuniqueMyRadarTarget) {
                CommuniqueMyRadarTarget mr = (CommuniqueMyRadarTarget)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " is scanning " + mr.name);
                target = TargetBank.getInstance().findByName(mr.name);
                if (target == null) continue;
                teammate.setScannerTarget(target);
                continue;
            }
            if (c instanceof CommuniqueMyBulletTarget) {
                CommuniqueMyBulletTarget mb = (CommuniqueMyBulletTarget)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " is aiming for " + mb.name);
                target = TargetBank.getInstance().findByName(mb.name);
                if (target == null) continue;
                teammate.setTurretTarget(target);
                continue;
            }
            if (c instanceof CommuniqueSuggestedRadarTarget) {
                CommuniqueSuggestedRadarTarget tr = (CommuniqueSuggestedRadarTarget)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " suggests scanning " + tr.name);
                target = TargetBank.getInstance().findByName(tr.name);
                if (target == null) continue;
                ScannerSubsystem.getInstance().considerTarget(target);
                continue;
            }
            if (c instanceof CommuniqueSuggestedBulletTarget) {
                CommuniqueSuggestedBulletTarget tb = (CommuniqueSuggestedBulletTarget)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " suggests aiming for " + tb.name);
                target = TargetBank.getInstance().findByName(tb.name);
                if (target == null) continue;
                TurretSubsystem.getInstance().considerTarget(target);
                continue;
            }
            if (c instanceof CommuniqueOther) {
                na = (CommuniqueOther)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " says " + na.message);
                continue;
            }
            if (c instanceof CommuniqueNotAvailable) {
                na = (CommuniqueNotAvailable)c;
                this.confirmTeamCommunication(String.valueOf(c.getSender()) + " tries to communicate " + ((CommuniqueNotAvailable)na).message);
                continue;
            }
            this.confirmTeamCommunication(String.valueOf(c.getSender()) + " fails to communicate.");
        }
    }

    private void confirmTeamCommunication(String message) {
        if (debug) {
            super.console(message);
        }
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Communiques in inbound queue: " + this.inbound.size());
        buffer.append("\n").append("Communiques in outbound queue: " + this.outbound.size());
        return buffer.toString();
    }
}

