/*
 * Decompiled with CFR 0.152.
 */
package labg.targeting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import labg.shooting.FactoredShootingStrategy;
import labg.shooting.ShootingStrategy;
import labg.targeting.TargetingStrategy;
import labg.util.Enemy;
import labg.util.Geometry;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class OptimalTargetingStrategy
extends TargetingStrategy {
    HashMap enemies;
    boolean goingForMin = false;
    int enemiesSeen = 0;
    double direction = 1.0;
    int count = 0;
    boolean singleTargMode = false;
    int targetSweeps = 0;
    double turnDirec = 1.0;
    FactoredShootingStrategy shootStrat = null;

    public OptimalTargetingStrategy(AdvancedRobot myBot, HashMap enemies, Enemy target) {
        super(myBot);
        this.enemies = enemies;
    }

    public void target() {
        if (this.myBot.getTime() < 30L) {
            this.myBot.setTurnRadarRight(360.0);
        } else if (!this.singleTargMode && this.myBot.getOthers() > 1) {
            Collection enemyColl = this.enemies.values();
            Iterator it = enemyColl.iterator();
            int numAlive = 0;
            while (it.hasNext()) {
                Enemy enTemp = (Enemy)it.next();
                if (!enTemp.isAlive) continue;
                ++numAlive;
            }
            if (this.enemiesSeen >= numAlive) {
                if (this.count == 10) {
                    this.count = 0;
                    this.enemiesSeen = 1;
                } else {
                    this.direction *= -1.0;
                    this.enemiesSeen = 0;
                    ++this.count;
                }
            }
            this.myBot.setTurnRadarRight(360.0 * this.direction);
        } else if (this.myBot.getTime() - this.target.timeLastSeen > 5L) {
            this.singleTargMode = false;
            this.targetSweeps = 0;
        } else {
            double radarMovement = this.target.currBearing + (this.myBot.getHeadingRadians() - this.myBot.getRadarHeadingRadians());
            this.turnDirec *= -1.0;
            this.myBot.setTurnRadarRightRadians(Geometry.normaliseBearing(radarMovement + 0.7853981633974483 * this.turnDirec));
        }
    }

    public void setShootingStrategy(ShootingStrategy fss) {
        this.shootStrat = (FactoredShootingStrategy)fss;
    }

    public void setEnemy(Enemy foe) {
        this.target = foe;
    }

    public Enemy getEnemy() {
        return this.target;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++this.enemiesSeen;
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }
}

