/*
 * Decompiled with CFR 0.152.
 */
package jrm;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.PaintEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Test0
extends AdvancedRobot {
    final double twoPI = Math.PI * 2;
    final double gunPower = 2.5;
    TreeSet<enemyBot> bots = new TreeSet();
    Random rnd = new Random();
    String targetName;
    double targetDirection;
    double targetDistance;
    double targetX;
    double targetY;
    double oldX;
    double oldY;
    double leadX;
    double leadY;
    int turnsWithoutTarget;
    int targetTimer = 0;
    private boolean acquiringTarget = false;
    private boolean haveTarget = false;
    private boolean backingAway = false;
    private double backingX;
    private double backingY;
    private double backingDirection;
    private byte forward = 1;
    private int backForthCount = 0;
    private boolean initialized = false;
    private TreeSet<Event> events = new TreeSet<Event>(new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            if (e1.getPriority() >= e2.getPriority()) {
                return 1;
            }
            return -1;
        }
    });
    private double radarTurn;
    private double gunTurn;
    private boolean moveGunAndRadar;

    private void initialize() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent(new Condition("moveAlmostDone"){

            public boolean test() {
                return Math.abs(Test0.this.getDistanceRemaining()) < 10.0;
            }
        });
        this.addCustomEvent(new Condition("gunCool"){

            public boolean test() {
                return Test0.this.getGunHeat() == 0.0;
            }
        });
        this.setEventPriority("ScannedRobotEvent", 90);
        this.acquireTarget();
        this.setAhead(20.0);
    }

    public void run() {
    }

    private void acquireTarget() {
        this.bots.clear();
        this.acquiringTarget = true;
        this.setTurnRadarRight(360.0);
        this.acquiringTarget = true;
    }

    public void processCustomEvent(CustomEvent e) {
        if (e.getCondition().getName().equals("robocode.RadarTurnCompleteCondition")) {
            if (this.acquiringTarget) {
                TreeSet<enemyBot> botsSorted = new TreeSet<enemyBot>(new Comparator<enemyBot>(){

                    @Override
                    public int compare(enemyBot bot1, enemyBot bot2) {
                        return Double.compare(bot1.distance, bot2.distance);
                    }
                });
                botsSorted.addAll(this.bots);
                if (!botsSorted.isEmpty()) {
                    this.targetName = botsSorted.first().name;
                    this.acquiringTarget = false;
                    this.haveTarget = true;
                    this.setTurnRadarRight(360.0);
                    this.execute();
                    this.out.println("Target Acquired: " + this.targetName);
                } else {
                    this.out.println("Could not find target");
                    this.acquireTarget();
                }
            }
        } else if (e.getCondition().getName().equals("moveAlmostDone")) {
            this.newMove();
        } else if (e.getCondition().getName().equals("gunCool") && this.haveTarget) {
            this.setFire(2.5);
        }
    }

    private void newMove() {
        if (!this.backingAway) {
            double direction;
            if (this.targetDistance > 300.0) {
                direction = this.targetDirection;
                this.setAhead(30.0);
            } else if (this.targetDistance < 100.0) {
                direction = this.targetDirection;
                this.setBack(30.0);
            } else {
                direction = Utils.normalRelativeAngle((double)(this.targetDirection + 1.5707963267948966));
                if (this.backForthCount-- <= 0) {
                    this.forward = (byte)(this.forward * -1);
                    this.backForthCount = (int)Math.abs(this.rnd.nextGaussian() * 3.0 + 5.0);
                }
                this.setAhead(30 * this.forward);
            }
            direction = Utils.normalRelativeAngle((double)(direction + this.rnd.nextGaussian()));
            this.setTurnRightRadians(direction);
        } else if (Math.sqrt(Math.pow(this.getX() - this.backingX, 2.0) + Math.pow(this.getY() - this.backingY, 2.0)) > 60.0) {
            this.backingAway = false;
            this.newMove();
        } else {
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(this.backingDirection - this.getHeadingRadians())));
            this.setBack(30.0);
        }
    }

    public void onStatus(StatusEvent arg0) {
        this.moveGunAndRadar = false;
        this.setInterruptible(false);
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        this.events.clear();
        this.events.addAll(this.getAllEvents());
        for (Event event : this.events) {
            if (event instanceof ScannedRobotEvent) {
                this.processScannedRobot((ScannedRobotEvent)event);
                continue;
            }
            if (event instanceof RobotDeathEvent) {
                this.processRobotDeath((RobotDeathEvent)event);
                continue;
            }
            if (event instanceof HitWallEvent) {
                this.processHit(((HitWallEvent)event).getBearingRadians());
                continue;
            }
            if (event instanceof HitRobotEvent) {
                this.processHit(((HitRobotEvent)event).getBearingRadians());
                continue;
            }
            if (event instanceof CustomEvent) {
                this.processCustomEvent((CustomEvent)event);
                continue;
            }
            if (!(event instanceof PaintEvent)) continue;
            this.onPaint(this.getGraphics());
        }
        if (this.turnsWithoutTarget++ > 10) {
            this.out.println("lost target");
            this.haveTarget = false;
            this.turnsWithoutTarget = 0;
            this.targetTimer = 0;
            this.acquireTarget();
        } else if (this.targetTimer++ > 100) {
            this.haveTarget = false;
            this.turnsWithoutTarget = 0;
            this.targetTimer = 0;
            this.acquireTarget();
        }
        if (this.moveGunAndRadar) {
            this.setTurnGunRightRadians(this.gunTurn);
            this.setTurnRadarRightRadians(2.0 * this.radarTurn);
            this.oldX = this.targetX;
            this.oldY = this.targetY;
        }
        this.execute();
    }

    public void processRobotDeath(RobotDeathEvent e) {
        this.bots.remove(new enemyBot(e.getName(), 0.0));
    }

    public void processScannedRobot(ScannedRobotEvent e) {
        boolean backwards = false;
        enemyBot bot = new enemyBot(e.getName(), e.getDistance());
        this.bots.remove(bot);
        this.bots.add(bot);
        if (!this.acquiringTarget && e.getName().equals(this.targetName)) {
            this.turnsWithoutTarget = 0;
            double bulletSpeed = 12.5;
            this.targetDistance = e.getDistance();
            double gunTime = this.targetDistance / bulletSpeed;
            this.targetDirection = e.getBearingRadians();
            double targetDirectionAbsolute = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + e.getBearingRadians()));
            this.targetX = this.getX() + Math.sin(targetDirectionAbsolute) * this.targetDistance;
            this.targetY = this.getY() + Math.cos(targetDirectionAbsolute) * this.targetDistance;
            double targetSpeed = Math.sqrt(Math.pow(this.targetX - this.oldX, 2.0) + Math.pow(this.targetY - this.oldY, 2.0));
            this.radarTurn = Utils.normalRelativeAngle((double)(targetDirectionAbsolute - this.getRadarHeadingRadians()));
            double targetTestDirection = Math.atan((this.targetX - this.oldX) / (this.targetY - this.oldY));
            if (this.targetY - this.oldY < 0.0) {
                targetTestDirection += Math.PI;
            }
            if (Math.abs(Math.abs(targetTestDirection - e.getHeadingRadians()) - Math.PI) < 1.0) {
                backwards = true;
            }
            double targetHeading = e.getHeadingRadians();
            if (backwards) {
                targetHeading = Utils.normalAbsoluteAngle((double)(targetHeading + Math.PI));
            }
            this.leadX = this.targetX + Math.sin(targetHeading) * targetSpeed * gunTime;
            this.leadY = this.targetY + Math.cos(targetHeading) * targetSpeed * gunTime;
            double leadDistance = Math.sqrt(Math.pow(this.leadX - this.getX(), 2.0) + Math.pow(this.leadY - this.getY(), 2.0));
            gunTime = leadDistance / bulletSpeed;
            this.leadX = this.targetX + Math.sin(targetHeading) * targetSpeed * gunTime;
            this.leadY = this.targetY + Math.cos(targetHeading) * targetSpeed * gunTime;
            double leadDirection = Math.atan((this.leadX - this.getX()) / (this.leadY - this.getY()));
            if (this.leadY - this.getY() < 0.0) {
                leadDirection += Math.PI;
            }
            this.gunTurn = Utils.normalRelativeAngle((double)(leadDirection - this.getGunHeadingRadians()));
            this.moveGunAndRadar = true;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void processHit(double bearingRadians) {
        this.forward = (byte)(this.forward * -1);
        this.setTurnRightRadians(bearingRadians);
        this.setAhead(-30.0);
        this.backingAway = true;
        this.backingDirection = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + bearingRadians));
        this.backingX = this.getX();
        this.backingY = this.getY();
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 0, 0, 128));
        g.fillRect((int)this.targetX - 25, (int)this.targetY - 25, 50, 50);
        g.setColor(new Color(0, 0, 255, 128));
        g.fillRect((int)this.leadX - 10, (int)this.leadY - 10, 20, 20);
        g.setColor(Color.green);
        g.drawOval((int)this.getX() - 50, (int)this.getY() - 50, 100, 100);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class enemyBot
    implements Comparable<enemyBot> {
        public String name;
        public double distance;

        enemyBot(String name, double distance) {
            this.name = name;
            this.distance = distance;
        }

        @Override
        public int compareTo(enemyBot e) {
            return this.name.compareTo(e.name);
        }
    }
}

