/*
 * Decompiled with CFR 0.152.
 */
package csm.genetic_trainer;

import csm.genetic_trainer.TrainableDouble;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class TrainableNumberCache
implements Serializable,
Comparable {
    private double score;
    Hashtable doubleCache;
    Vector doubleNums;
    Vector doubleNames;
    private static int FIXED_SINGLE_CROSSOVER_POINT = 1;
    private static int RANDOM_SINGLE_CROSSOVER_POINT = 2;
    private static int RANDOM_GENE_CROSSOVER = 3;
    private static int FIXED_MULTIPLE_CROSSOVER_POINT = 4;
    private static int RANDOM_MULTIPLE_CROSSOVER_POINT = 5;
    private boolean testingMode;

    public TrainableNumberCache() {
        this.score = 0.0;
        this.doubleCache = null;
        this.doubleNums = null;
        this.doubleNames = null;
        this.testingMode = false;
        this.doubleCache = new Hashtable();
        this.doubleNums = new Vector();
        this.doubleNames = new Vector();
    }

    public TrainableNumberCache copy() {
        TrainableNumberCache clone = new TrainableNumberCache(this, this, 1);
        clone.setScore(this.score);
        return clone;
    }

    public TrainableNumberCache(TrainableNumberCache father, TrainableNumberCache mother, int crossoverType) {
        block11: {
            Random generator;
            Vector motherNames;
            Vector motherDoubles;
            Vector fatherNames;
            Vector fatherDoubles;
            block10: {
                this.score = 0.0;
                this.doubleCache = null;
                this.doubleNums = null;
                this.doubleNames = null;
                this.testingMode = false;
                this.doubleCache = new Hashtable();
                this.doubleNums = new Vector();
                this.doubleNames = new Vector();
                fatherDoubles = father.getDoubleNums();
                fatherNames = father.getDoubleNames();
                motherDoubles = mother.getDoubleNums();
                motherNames = mother.getDoubleNames();
                int singleCrossoverPoint = 0;
                generator = new Random(System.currentTimeMillis());
                if (crossoverType == FIXED_SINGLE_CROSSOVER_POINT) {
                    singleCrossoverPoint = fatherDoubles.size() / 2;
                } else if (crossoverType == RANDOM_SINGLE_CROSSOVER_POINT) {
                    singleCrossoverPoint = generator.nextInt(fatherDoubles.size());
                }
                if (crossoverType != FIXED_SINGLE_CROSSOVER_POINT && crossoverType != RANDOM_SINGLE_CROSSOVER_POINT) break block10;
                int i = 0;
                while (i < singleCrossoverPoint) {
                    TrainableDouble d = (TrainableDouble)fatherDoubles.elementAt(i);
                    String s = (String)fatherNames.elementAt(i);
                    this.getDouble(s, d.getVal(), d.getMinVal(), d.getMaxVal());
                    ++i;
                }
                int i2 = singleCrossoverPoint;
                while (i2 < motherDoubles.size()) {
                    TrainableDouble d = (TrainableDouble)motherDoubles.elementAt(i2);
                    String s = (String)motherNames.elementAt(i2);
                    this.getDouble(s, d.getVal(), d.getMinVal(), d.getMaxVal());
                    ++i2;
                }
                break block11;
            }
            if (crossoverType != RANDOM_GENE_CROSSOVER) break block11;
            int i = 0;
            while (i < Math.max(fatherDoubles.size(), motherDoubles.size())) {
                TrainableDouble d = null;
                String s = null;
                if (generator.nextBoolean()) {
                    d = (TrainableDouble)fatherDoubles.elementAt(i);
                    s = (String)fatherNames.elementAt(i);
                    if (d == null) {
                        d = (TrainableDouble)motherDoubles.elementAt(i);
                        s = (String)motherNames.elementAt(i);
                    }
                } else {
                    d = (TrainableDouble)motherDoubles.elementAt(i);
                    s = (String)motherNames.elementAt(i);
                    if (d == null) {
                        d = (TrainableDouble)fatherDoubles.elementAt(i);
                        s = (String)fatherNames.elementAt(i);
                    }
                }
                this.getDouble(s, d.getVal(), d.getMinVal(), d.getMaxVal());
                ++i;
            }
        }
    }

    public void mutate(double baseMutationRate, double resolution, Random r) {
        Enumeration e = this.doubleNums.elements();
        while (e.hasMoreElements()) {
            TrainableDouble d = (TrainableDouble)e.nextElement();
            d.mutate(baseMutationRate, resolution, r);
        }
    }

    public void dumpGene() {
        int i = 0;
        while (i < this.doubleNums.size()) {
            String name = (String)this.doubleNames.elementAt(i);
            TrainableDouble d = (TrainableDouble)this.doubleNums.elementAt(i);
            System.out.println(name + "    :  " + d.getVal());
            ++i;
        }
    }

    public double getDouble(String numberTag, double defaultVal, double minVal, double maxVal) {
        TrainableDouble d = (TrainableDouble)this.doubleCache.get(numberTag);
        if (d == null) {
            d = new TrainableDouble(defaultVal, minVal, maxVal);
            this.doubleCache.put(numberTag, d);
            this.doubleNums.add(d);
            this.doubleNames.add(numberTag);
        }
        if (this.testingMode) {
            return d.getInitialVal();
        }
        return d.getVal();
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public Vector getDoubleNums() {
        return this.doubleNums;
    }

    public void setDoubleNums(Vector doubleNums) {
        this.doubleNums = doubleNums;
    }

    public Vector getDoubleNames() {
        return this.doubleNames;
    }

    public void setDoubleNames(Vector doubleNames) {
        this.doubleNames = doubleNames;
    }

    public int compareTo(Object obj) {
        TrainableNumberCache comparison = (TrainableNumberCache)obj;
        return (int)(this.score - comparison.getScore());
    }

    public boolean isTestingMode() {
        return this.testingMode;
    }

    public void setTestingMode(boolean testingMode) {
        this.testingMode = testingMode;
    }
}

