/*
 * Decompiled with CFR 0.152.
 */
package pla;

import pla.Constants;

public final class Trig
implements Constants {
    public static double shortestAngleRad(double currDirection, double newDirection) {
        double a = (newDirection - currDirection) % (Math.PI * 2);
        if (a < -Math.PI) {
            return a + Math.PI * 2;
        }
        if (a > Math.PI) {
            return a - Math.PI * 2;
        }
        return a;
    }

    public static double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Trig.calcDistance(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public static double calcDistance(double fromX, double fromY, double toX, double toY) {
        return Math.sqrt(Math.pow(toY - fromY, 2.0) + Math.pow(toX - fromX, 2.0));
    }

    public static double calcX(double x, double heading, double distance) {
        return x + Trig.sin(heading) * distance;
    }

    public static double calcY(double y, double heading, double distance) {
        return y + Trig.cos(heading) * distance;
    }

    public static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }

    public static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    public static double tan(double angle) {
        return Math.tan(Math.toRadians(angle));
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double atan(double angle) {
        return Math.toDegrees(Math.atan(angle));
    }

    public static double asin(double angle) {
        return Math.toDegrees(Math.asin(angle));
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double limit(double number, double lowerLimit, double upperLimit) {
        return Math.max(Math.min(number, upperLimit), lowerLimit);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static double round2(double a) {
        return (double)Math.round(a * 100.0) / 100.0;
    }

    public static double toDegrees(double angle) {
        return Math.toDegrees(angle);
    }

    public static double toRadians(double angle) {
        return Math.toRadians(angle);
    }
}

