/*
 * Decompiled with CFR 0.152.
 */
package jaw;

import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

public class Mouse
extends AdvancedRobot {
    private static final double R90 = 1.5707963267948966;
    private static final double R45 = 0.7853981633974483;
    private static final double R20 = 0.3490658503988659;
    private static final double R10 = 0.17453292519943295;
    private static Random random = new Random();
    double direction = -1.0;
    public double targetAbsoluteBearing;
    public double targetHeadingRadians;
    public double targetVelocity;
    public double targetDistance;
    public double targetEnergy;
    public double targetX;
    public double targetY;
    public long targetStartTime;
    private double targetRadarOffset = 0.7853981633974483;
    private boolean targetShot;

    public double guessTargetX(long when) {
        return this.targetX + Math.sin(this.targetHeadingRadians) * this.targetVelocity * (double)(when - this.targetStartTime);
    }

    public double guessTargetY(long when) {
        return this.targetY + Math.cos(this.targetHeadingRadians) * this.targetVelocity * (double)(when - this.targetStartTime);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.movement();
            this.gun();
            this.radar();
            this.execute();
        }
    }

    void gun() {
        long time = this.getTime() + (long)this.targetDistance / 11L;
        if (this.getGunHeat() == 0.0 && this.getTime() - this.targetStartTime < 10L && Math.max(0.01, (200.0 - this.targetDistance) / 1000.0) > Math.abs(Math.asin(Math.sin(this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.guessTargetX(time), this.guessTargetY(time)))))) {
            this.setFire(3.0);
        } else {
            this.setTurnGunLeftRadians(Math.asin(Math.sin(this.getGunHeadingRadians() - this.absbearing(this.getX() + Math.sin(this.getHeadingRadians()) * this.getVelocity(), this.getY() + Math.cos(this.getHeadingRadians()) * this.getVelocity(), this.guessTargetX(++time), this.guessTargetY(time)))));
        }
    }

    private void radar() {
        if (this.getTime() - this.targetStartTime < 5L) {
            this.targetRadarOffset = this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.targetX, this.targetY);
            if (this.targetRadarOffset < 0.0) {
                this.setTurnRadarLeftRadians(Math.max(-0.3490658503988659, this.targetRadarOffset - 0.17453292519943295));
            } else {
                this.setTurnRadarLeftRadians(Math.min(0.3490658503988659, this.targetRadarOffset + 0.17453292519943295));
            }
        } else {
            this.setTurnRadarLeftRadians(this.targetRadarOffset * 2.0);
        }
    }

    public void movement() {
        if (this.targetShot) {
            this.direction = random.nextBoolean() ? -1 : 1;
            this.setAhead(this.direction * 90.0);
            this.targetShot = false;
        }
        this.setTurnRightRadians(this.direction * Math.max(Math.min(0.7853981633974483 * (100.0 - this.targetDistance) / 100.0, 0.7853981633974483), -0.7853981633974483) + this.targetAbsoluteBearing - this.getHeadingRadians() + 1.5707963267948966);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.targetShot = this.getTime() - this.targetStartTime < 3L && this.targetEnergy != e.getEnergy();
        this.targetStartTime = this.getTime();
        this.targetAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.targetHeadingRadians = e.getHeadingRadians();
        this.targetEnergy = e.getEnergy();
        this.targetDistance = e.getDistance();
        this.targetVelocity = e.getVelocity();
        this.targetX = this.getX() + Math.sin(this.targetAbsoluteBearing) * this.targetDistance;
        this.targetY = this.getY() + Math.cos(this.targetAbsoluteBearing) * this.targetDistance;
    }

    public void onHitWall(HitWallEvent event) {
        this.direction *= -1.0;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (xo > 0.0) {
            if (yo > 0.0) {
                return Math.asin(xo / h);
            }
            return Math.PI - Math.asin(xo / h);
        }
        if (yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        return Math.PI * 2 - Math.asin(-xo / h);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.targetEnergy = e.getEnergy();
    }
}

