/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.util.ArrayList;
import java.util.List;
import learn.Connection;

class Neuron {
    private double m_outputVal;
    private List<Connection> m_outputWeights = new ArrayList<Connection>();
    private int m_myIndex;
    private double m_gradient;
    private static double eta = 0.07;
    private static double alpha = 0.45;

    Neuron(int numOutputs, int myIndex) {
        int c = 0;
        while (c < numOutputs) {
            this.m_outputWeights.add(new Connection());
            ++c;
        }
        this.m_myIndex = myIndex;
    }

    void feedForward(List<Neuron> prevLayer) {
        double sum = 0.0;
        int n = 0;
        while (n < prevLayer.size()) {
            sum += prevLayer.get(n).getOutputVal() * prevLayer.get((int)n).m_outputWeights.get((int)this.m_myIndex).weight;
            ++n;
        }
        this.m_outputVal = Neuron.transferFunction(sum);
    }

    void calcOutputGradients(double targetVal) {
        double delta = targetVal - this.m_outputVal;
        this.m_gradient = delta * Neuron.transferFunctionDerivative(this.m_outputVal);
    }

    void calcHiddenGradients(List<Neuron> nextLayer) {
        double dow = this.sumDOW(nextLayer);
        this.m_gradient = dow * Neuron.transferFunctionDerivative(this.m_outputVal);
    }

    void updateInputWeights(List<Neuron> prevLayer) {
        int n = 0;
        while (n < prevLayer.size()) {
            double newDeltaWeight;
            Neuron neuron = prevLayer.get(n);
            double oldDeltaWeight = neuron.m_outputWeights.get((int)this.m_myIndex).deltaWeight;
            neuron.m_outputWeights.get((int)this.m_myIndex).deltaWeight = newDeltaWeight = eta * neuron.getOutputVal() * this.m_gradient + alpha * oldDeltaWeight;
            neuron.m_outputWeights.get((int)this.m_myIndex).weight += newDeltaWeight;
            ++n;
        }
    }

    void setOutputVal(double val) {
        this.m_outputVal = val;
    }

    final double getOutputVal() {
        return this.m_outputVal;
    }

    private static double randomWeight() {
        return Math.random();
    }

    private static double transferFunction(double x) {
        return Math.tanh(x);
    }

    private static double transferFunctionDerivative(double x) {
        return 1.0 - x * x;
    }

    private final double sumDOW(List<Neuron> nextLayer) {
        double sum = 0.0;
        int n = 0;
        while (n < nextLayer.size() - 1) {
            sum += this.m_outputWeights.get((int)n).weight * nextLayer.get((int)n).m_gradient;
            ++n;
        }
        return sum;
    }
}

