/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.movement.manager;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SurferScan
implements Cloneable {
    public double lateralVelocity;
    public double advancingVelocity;
    public int direction = 1;
    public double absBearing;
    public double distance;
    public int timeSinceDirChange = 0;
    public double wallDistance;
    public double velocity;
    public double acceleration;
    public double turning;
    public double heading;

    public void update(AdvancedRobot robot, ScannedRobotEvent e) {
        double oldVelocity = this.velocity;
        this.acceleration = this.velocity - oldVelocity;
        this.velocity = robot.getVelocity();
        this.lateralVelocity = this.velocity * Math.sin(e.getBearingRadians());
        this.advancingVelocity = this.velocity * Math.cos(e.getBearingRadians());
        this.absBearing = e.getBearingRadians() + robot.getHeadingRadians();
        this.distance = e.getDistance();
        int oldDirection = this.direction;
        if (Math.abs(this.lateralVelocity) > 0.1) {
            int n = this.direction = this.lateralVelocity >= 0.0 ? 1 : -1;
        }
        this.timeSinceDirChange = (double)(oldDirection * this.direction) < 0.0 ? 0 : ++this.timeSinceDirChange;
        this.wallDistance = this.calcWallDistance(robot, robot.getX(), robot.getY());
        this.turning = Utils.normalRelativeAngle((double)(robot.getHeadingRadians() - this.heading));
        this.heading = robot.getHeadingRadians();
    }

    private double calcWallDistance(AdvancedRobot robot, double x, double y) {
        return Math.min(Math.min(x, robot.getBattleFieldHeight() - x), Math.min(y, robot.getBattleFieldWidth() - y));
    }

    public SurferScan clone() throws CloneNotSupportedException {
        return (SurferScan)super.clone();
    }
}

